/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.HeaderKeys;
import COSE.KeyKeys;
import COSE.Message;
import COSE.OneKey;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Recipient
extends Message {
    OneKey privateKey;
    private OneKey senderKey;
    byte[] rgbEncrypted;
    List<Recipient> recipientList;

    @Override
    public void DecodeFromCBORObject(CBORObject objRecipient) throws CoseException {
        if (objRecipient.size() != 3 && objRecipient.size() != 4) {
            throw new CoseException("Invalid Recipient structure");
        }
        if (objRecipient.get(0).getType() == CBORType.ByteString) {
            this.objProtected = objRecipient.get(0).GetByteString().length == 0 ? CBORObject.NewMap() : CBORObject.DecodeFromBytes(objRecipient.get(0).GetByteString());
        } else {
            throw new CoseException("Invalid Recipient structure");
        }
        if (objRecipient.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid Recipient structure");
        }
        this.objUnprotected = objRecipient.get(1);
        if (objRecipient.get(2).getType() != CBORType.ByteString) {
            throw new CoseException("Invalid Recipient structure");
        }
        this.rgbEncrypted = objRecipient.get(2).GetByteString();
        if (objRecipient.size() == 4) {
            if (objRecipient.get(3).getType() == CBORType.Array) {
                this.recipientList = new ArrayList<Recipient>();
                for (int i = 0; i < objRecipient.get(3).size(); ++i) {
                    Recipient recipX = new Recipient();
                    recipX.DecodeFromCBORObject(objRecipient.get(3).get(i));
                    this.recipientList.add(recipX);
                }
            } else {
                throw new CoseException("Invalid Recipient structure");
            }
        }
    }

    @Override
    protected CBORObject EncodeCBORObject() throws CoseException {
        CBORObject obj = CBORObject.NewArray();
        if (this.objProtected.size() > 0) {
            obj.Add(this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject(new byte[0]));
        }
        obj.Add(this.objUnprotected);
        obj.Add(this.rgbEncrypted);
        if (this.recipientList != null) {
            CBORObject objR = CBORObject.NewArray();
            for (Recipient r : this.recipientList) {
                objR.Add(r.EncodeCBORObject());
            }
            obj.Add(objR);
        }
        return obj;
    }

    public byte[] decrypt(AlgorithmID algCEK, Recipient recip) throws CoseException {
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        byte[] rgbKey = null;
        if (recip != this) {
            for (Recipient r : this.recipientList) {
                if (recip == r) {
                    rgbKey = r.decrypt(alg, recip);
                    if (rgbKey != null) break;
                    throw new CoseException("Internal error");
                }
                if (r.recipientList.isEmpty() || (rgbKey = r.decrypt(alg, recip)) == null) continue;
                break;
            }
        }
        switch (alg) {
            case Direct: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Mismatch of algorithm and key");
                }
                return this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString();
            }
            case HKDF_HMAC_SHA_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Needs to be an octet key");
                }
                return this.HKDF(this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString(), algCEK.getKeySize(), algCEK, "SHA256");
            }
            case HKDF_HMAC_SHA_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Needs to be an octet key");
                }
                return this.HKDF(this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString(), algCEK.getKeySize(), algCEK, "SHA512");
            }
            case AES_KW_128: 
            case AES_KW_192: 
            case AES_KW_256: {
                if (rgbKey == null) {
                    if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                        throw new CoseException("Key and algorithm do not agree");
                    }
                    rgbKey = this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString();
                } else if (this.privateKey != null) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                return this.AES_KeyWrap_Decrypt(alg, rgbKey);
            }
            case ECDH_ES_HKDF_256: 
            case ECDH_SS_HKDF_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                return this.HKDF(rgbKey, algCEK.getKeySize(), algCEK, "SHA256");
            }
            case ECDH_ES_HKDF_512: 
            case ECDH_SS_HKDF_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                return this.HKDF(rgbKey, algCEK.getKeySize(), algCEK, "SHA512");
            }
            case ECDH_ES_HKDF_256_AES_KW_128: 
            case ECDH_SS_HKDF_256_AES_KW_128: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 128, AlgorithmID.AES_KW_128, "SHA256");
                return this.AES_KeyWrap_Decrypt(AlgorithmID.AES_KW_128, rgbKey);
            }
            case ECDH_ES_HKDF_256_AES_KW_192: 
            case ECDH_SS_HKDF_256_AES_KW_192: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 192, AlgorithmID.AES_KW_192, "SHA256");
                return this.AES_KeyWrap_Decrypt(AlgorithmID.AES_KW_192, rgbKey);
            }
            case ECDH_ES_HKDF_256_AES_KW_256: 
            case ECDH_SS_HKDF_256_AES_KW_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 256, AlgorithmID.AES_KW_256, "SHA256");
                return this.AES_KeyWrap_Decrypt(AlgorithmID.AES_KW_256, rgbKey);
            }
        }
        throw new CoseException("Unsupported Recipent Algorithm");
    }

    public void encrypt() throws CoseException {
        SecureRandom random;
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        byte[] rgbKey = null;
        int recipientTypes = 0;
        if (this.recipientList != null && !this.recipientList.isEmpty()) {
            if (this.privateKey != null) {
                throw new CoseException("Cannot have dependent recipients if key is specified");
            }
            block14: for (Recipient r : this.recipientList) {
                switch (r.getRecipientType()) {
                    case 1: {
                        if ((recipientTypes & 1) != 0) {
                            throw new CoseException("Cannot have two direct recipients");
                        }
                        recipientTypes |= 1;
                        rgbKey = r.getKey(alg);
                        continue block14;
                    }
                }
                recipientTypes |= 2;
            }
        }
        if (recipientTypes == 3) {
            throw new CoseException("Do not mix direct and indirect recipients");
        }
        if (recipientTypes == 2) {
            rgbKey = new byte[alg.getKeySize() / 8];
            random = new SecureRandom();
            random.nextBytes(rgbKey);
        }
        switch (alg) {
            case Direct: 
            case HKDF_HMAC_SHA_256: 
            case HKDF_HMAC_SHA_512: {
                this.rgbEncrypted = new byte[0];
                break;
            }
            case AES_KW_128: 
            case AES_KW_192: 
            case AES_KW_256: {
                if (rgbKey == null) {
                    if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                        throw new CoseException("Key and algorithm do not agree");
                    }
                    rgbKey = this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString();
                }
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(alg, rgbKey);
                break;
            }
            case ECDH_ES_HKDF_256: 
            case ECDH_SS_HKDF_256: 
            case ECDH_ES_HKDF_512: 
            case ECDH_SS_HKDF_512: {
                this.rgbEncrypted = new byte[0];
                break;
            }
            case ECDH_ES_HKDF_256_AES_KW_128: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenEphemeral();
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 128, AlgorithmID.AES_KW_128, "SHA256");
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_128, rgbKey);
                break;
            }
            case ECDH_SS_HKDF_256_AES_KW_128: {
                byte[] rgbAPU;
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    rgbAPU = new byte[32];
                    random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject(rgbAPU), 2);
                }
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 128, AlgorithmID.AES_KW_128, "SHA256");
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_128, rgbKey);
                break;
            }
            case ECDH_ES_HKDF_256_AES_KW_192: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenEphemeral();
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 192, AlgorithmID.AES_KW_192, "SHA256");
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_192, rgbKey);
                break;
            }
            case ECDH_SS_HKDF_256_AES_KW_192: {
                byte[] rgbAPU;
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    rgbAPU = new byte[32];
                    random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject(rgbAPU), 2);
                }
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 192, AlgorithmID.AES_KW_192, "SHA256");
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_192, rgbKey);
                break;
            }
            case ECDH_ES_HKDF_256_AES_KW_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenEphemeral();
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 256, AlgorithmID.AES_KW_256, "SHA256");
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_256, rgbKey);
                break;
            }
            case ECDH_SS_HKDF_256_AES_KW_256: {
                byte[] rgbAPU;
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    rgbAPU = new byte[32];
                    random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject(rgbAPU), 2);
                }
                rgbKey = this.ECDH_GenSecret(this.privateKey);
                rgbKey = this.HKDF(rgbKey, 256, AlgorithmID.AES_KW_256, "SHA256");
                this.rgbEncrypted = this.AES_KeyWrap_Encrypt(AlgorithmID.AES_KW_256, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported Recipient Algorithm");
            }
        }
        if (this.recipientList != null) {
            for (Recipient r : this.recipientList) {
                r.SetContent(rgbKey);
                r.encrypt();
            }
        }
    }

    public void addRecipient(Recipient recipient) {
        if (this.recipientList == null) {
            this.recipientList = new ArrayList<Recipient>();
        }
        this.recipientList.add(recipient);
    }

    public List<Recipient> getRecipientList() {
        return this.recipientList;
    }

    public Recipient getRecipient(int iRecipient) {
        return this.recipientList.get(iRecipient);
    }

    public int getRecipientCount() {
        return this.recipientList.size();
    }

    public int getRecipientType() throws CoseException {
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        switch (alg) {
            case Direct: 
            case HKDF_HMAC_SHA_256: 
            case HKDF_HMAC_SHA_512: 
            case ECDH_ES_HKDF_256: 
            case ECDH_SS_HKDF_256: 
            case ECDH_ES_HKDF_512: 
            case ECDH_SS_HKDF_512: {
                return 1;
            }
        }
        return 9;
    }

    public byte[] getKey(AlgorithmID algCEK) throws CoseException {
        if (this.privateKey == null) {
            throw new CoseException("Private key not set for recipient");
        }
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        switch (alg) {
            case Direct: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                return this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString();
            }
            case AES_KW_128: 
            case AES_KW_192: 
            case AES_KW_256: {
                if (!this.privateKey.HasKeyType(KeyKeys.KeyType_Octet)) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                return this.privateKey.get(KeyKeys.Octet_K).GetByteString();
            }
            case ECDH_ES_HKDF_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenEphemeral();
                byte[] rgbSecret = this.ECDH_GenSecret(this.privateKey);
                return this.HKDF(rgbSecret, algCEK.getKeySize(), algCEK, "SHA256");
            }
            case ECDH_ES_HKDF_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                this.ECDH_GenEphemeral();
                byte[] rgbSecret = this.ECDH_GenSecret(this.privateKey);
                return this.HKDF(rgbSecret, algCEK.getKeySize(), algCEK, "SHA512");
            }
            case ECDH_SS_HKDF_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    byte[] rgbAPU = new byte[32];
                    SecureRandom random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject(rgbAPU), 2);
                }
                byte[] rgbSecret = this.ECDH_GenSecret(this.privateKey);
                return this.HKDF(rgbSecret, algCEK.getKeySize(), algCEK, "SHA256");
            }
            case ECDH_SS_HKDF_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
                    throw new CoseException("Key and algorithm do not agree");
                }
                if (this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR()) == null) {
                    byte[] rgbAPU = new byte[64];
                    SecureRandom random = new SecureRandom();
                    random.nextBytes(rgbAPU);
                    this.addAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR(), CBORObject.FromObject(rgbAPU), 2);
                }
                byte[] rgbSecret = this.ECDH_GenSecret(this.privateKey);
                return this.HKDF(rgbSecret, algCEK.getKeySize(), algCEK, "SHA512");
            }
            case HKDF_HMAC_SHA_256: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Needs to be an octet key");
                }
                return this.HKDF(this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString(), algCEK.getKeySize(), algCEK, "SHA256");
            }
            case HKDF_HMAC_SHA_512: {
                if (this.privateKey.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_Octet) {
                    throw new CoseException("Needs to be an octet key");
                }
                return this.HKDF(this.privateKey.get(KeyKeys.Octet_K.AsCBOR()).GetByteString(), algCEK.getKeySize(), algCEK, "SHA512");
            }
        }
        throw new CoseException("Recipient Algorithm not supported");
    }

    @Deprecated
    public void SetKey(CBORObject key) throws CoseException {
        this.privateKey = new OneKey(key);
    }

    public void SetKey(OneKey key) {
        this.privateKey = key;
    }

    @Deprecated
    public void SetSenderKey(CBORObject key) throws CoseException {
        this.senderKey = new OneKey(key);
    }

    public void SetSenderKey(OneKey key) {
        this.senderKey = key;
    }

    private byte[] AES_KeyWrap_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key is not the correct size");
        }
        try {
            Cipher cipher = Cipher.getInstance("AESWrap");
            cipher.init(3, new SecretKeySpec(rgbKey, "AESWrap"));
            return cipher.wrap(new SecretKeySpec(this.rgbContent, "AES"));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Key Wrap failure", ex);
        }
    }

    private byte[] AES_KeyWrap_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException {
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key is not the correct size");
        }
        try {
            Cipher cipher = Cipher.getInstance("AESWrap");
            cipher.init(4, new SecretKeySpec(rgbKey, "AESWrap"));
            return ((SecretKeySpec)cipher.unwrap(this.rgbEncrypted, "AES", 3)).getEncoded();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (InvalidKeyException ex) {
            if (ex.getMessage() == "Illegal key size") {
                throw new CoseException("Unsupported key size", ex);
            }
            throw new CoseException("Decryption failure", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Key Unwrap failure", ex);
        }
    }

    private void ECDH_GenEphemeral() throws CoseException {
        OneKey secretKey = OneKey.generateKey(this.privateKey.get(KeyKeys.EC2_Curve));
        CBORObject epk = secretKey.PublicKey().AsCBOR();
        this.addAttribute(HeaderKeys.ECDH_EPK, epk, 2);
        this.senderKey = secretKey;
    }

    private byte[] ECDH_GenSecret(OneKey key) throws CoseException {
        OneKey epk;
        if (this.senderKey != null) {
            epk = key;
            key = this.senderKey;
        } else {
            CBORObject cn = this.findAttribute(HeaderKeys.ECDH_SPK);
            if (cn == null) {
                cn = this.findAttribute(HeaderKeys.ECDH_EPK);
            }
            if (cn == null) {
                throw new CoseException("No second party EC key");
            }
            epk = new OneKey(cn);
        }
        if (key.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
            throw new CoseException("Not an EC2 Key");
        }
        if (epk.get(KeyKeys.KeyType.AsCBOR()) != KeyKeys.KeyType_EC2) {
            throw new CoseException("Not an EC2 Key");
        }
        if (epk.get(KeyKeys.EC2_Curve.AsCBOR()) != key.get(KeyKeys.EC2_Curve.AsCBOR())) {
            throw new CoseException("Curves are not the same");
        }
        try {
            PublicKey pubKey = epk.AsPublicKey();
            PrivateKey privKey = key.AsPrivateKey();
            KeyAgreement ecdh = KeyAgreement.getInstance("ECDH");
            ecdh.init(privKey);
            ecdh.doPhase(pubKey, true);
            return ecdh.generateSecret();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Key agreement failure", ex);
        }
    }

    private byte[] HKDF(byte[] secret, int cbitKey, AlgorithmID alg, String digest) throws CoseException {
        String HMAC_ALG_NAME = "Hmac" + digest;
        byte[] rgbContext = this.GetKDFInput(cbitKey, alg);
        try {
            Mac hmac = Mac.getInstance(HMAC_ALG_NAME);
            int hashLen = hmac.getMacLength();
            CBORObject cnSalt = this.findAttribute(HeaderKeys.HKDF_Salt.AsCBOR());
            byte[] K = cnSalt == null ? new byte[hashLen] : cnSalt.GetByteString();
            hmac.init(new SecretKeySpec(K, HMAC_ALG_NAME));
            byte[] rgbExtract = hmac.doFinal(secret);
            hmac.init(new SecretKeySpec(rgbExtract, HMAC_ALG_NAME));
            int c = ((cbitKey + 7) / 8 + hashLen - 1) / hashLen;
            byte[] rgbOut = new byte[cbitKey / 8];
            byte[] T = new byte[hashLen * c];
            byte[] last = new byte[]{};
            for (int i = 0; i < c; ++i) {
                hmac.reset();
                hmac.update(last);
                hmac.update(rgbContext);
                hmac.update((byte)(i + 1));
                last = hmac.doFinal();
                System.arraycopy(last, 0, T, i * hashLen, hashLen);
            }
            System.arraycopy(T, 0, rgbOut, 0, cbitKey / 8);
            return rgbOut;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CoseException("Algorithm not supported", ex);
        }
        catch (Exception ex) {
            throw new CoseException("Derivation failure", ex);
        }
    }

    private byte[] GetKDFInput(int cbitKey, AlgorithmID algorithmID) {
        CBORObject contextArray = CBORObject.NewArray();
        contextArray.Add(algorithmID.AsCBOR());
        CBORObject info = CBORObject.NewArray();
        contextArray.Add(info);
        CBORObject obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyU_ID.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyU_nonce.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyU_Other.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        info = CBORObject.NewArray();
        contextArray.Add(info);
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyV_ID.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyV_nonce.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        obj = this.findAttribute(HeaderKeys.HKDF_Context_PartyV_Other.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        } else {
            info.Add(null);
        }
        info = CBORObject.NewArray();
        contextArray.Add(info);
        info.Add(CBORObject.FromObject(cbitKey));
        if (this.objProtected.size() == 0) {
            info.Add(new byte[0]);
        } else {
            info.Add(this.objProtected.EncodeToBytes());
        }
        obj = this.findAttribute(HeaderKeys.HKDF_SuppPub_Other.AsCBOR());
        if (obj != null) {
            info.Add(obj);
        }
        if ((obj = this.findAttribute(HeaderKeys.HKDF_SuppPriv_Other.AsCBOR())) != null) {
            contextArray.Add(obj);
        }
        return contextArray.EncodeToBytes();
    }
}

