/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.yubico.webauthn.data.ByteArray;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public enum COSEAlgorithmIdentifier {
    EdDSA(-8L),
    ES256(-7L),
    ES384(-35L),
    ES512(-36L),
    RS256(-257L),
    RS384(-258L),
    RS512(-259L),
    RS1(-65535L);

    @JsonValue
    private final long id;

    private COSEAlgorithmIdentifier(long id) {
        this.id = id;
    }

    public static Optional<COSEAlgorithmIdentifier> fromId(long id) {
        return Stream.of(COSEAlgorithmIdentifier.values()).filter(v -> v.id == id).findAny();
    }

    public static Optional<COSEAlgorithmIdentifier> fromPublicKey(@NonNull ByteArray publicKeyCose) {
        int alg;
        if (publicKeyCose == null) {
            throw new NullPointerException("publicKeyCose is marked non-null but is null");
        }
        CBORObject ALG = CBORObject.FromObject(3);
        try {
            CBORObject cose = CBORObject.DecodeFromBytes(publicKeyCose.getBytes());
            if (!cose.ContainsKey(ALG)) {
                throw new IllegalArgumentException("Public key does not contain an \"alg\"(3) value: " + publicKeyCose);
            }
            CBORObject algCbor = cose.get(ALG);
            if (!algCbor.isNumber() || !algCbor.AsNumber().IsInteger()) {
                throw new IllegalArgumentException("Public key has non-integer \"alg\"(3) value: " + publicKeyCose);
            }
            alg = algCbor.AsInt32();
        }
        catch (CBORException e) {
            throw new IllegalArgumentException("Failed to parse public key", e);
        }
        return COSEAlgorithmIdentifier.fromId(alg);
    }

    @JsonCreator
    private static COSEAlgorithmIdentifier fromJson(long id) {
        return COSEAlgorithmIdentifier.fromId(id).orElseThrow(() -> new IllegalArgumentException("Unknown COSE algorithm identifier: " + id));
    }

    @Generated
    public long getId() {
        return this.id;
    }
}

