/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.meta;

import com.yubico.internal.util.ExceptionUtil;
import com.yubico.webauthn.meta.DocumentStatus;
import com.yubico.webauthn.meta.Implementation;
import com.yubico.webauthn.meta.Specification;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Manifest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionInfo.class);
    private static VersionInfo instance;
    private final Specification specification = Specification.builder().url(new URL(this.findValueInManifest("Specification-Url"))).latestVersionUrl(new URL(this.findValueInManifest("Specification-Url-Latest"))).status(DocumentStatus.fromString(this.findValueInManifest("Specification-W3c-Status")).get()).releaseDate(LocalDate.parse(this.findValueInManifest("Specification-Release-Date"))).build();
    private final Implementation implementation = new Implementation(this.findValueInManifest("Implementation-Version"), new URL(this.findValueInManifest("Implementation-Source-Url")), this.findValueInManifest("Git-Commit"));

    public static VersionInfo getInstance() {
        if (instance == null) {
            try {
                instance = new VersionInfo();
            }
            catch (IOException e) {
                throw ExceptionUtil.wrapAndLog(log, "Failed to create VersionInfo", e);
            }
        }
        return instance;
    }

    private VersionInfo() throws IOException {
    }

    private String findValueInManifest(String key) throws IOException {
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            Manifest manifest = new Manifest(resource.openStream());
            if (!"java-webauthn-server".equals(manifest.getMainAttributes().getValue("Implementation-Id"))) continue;
            return manifest.getMainAttributes().getValue(key);
        }
        throw new NoSuchElementException("Could not find \"" + key + "\" in manifest.");
    }

    @Generated
    public Specification getSpecification() {
        return this.specification;
    }

    @Generated
    public Implementation getImplementation() {
        return this.implementation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)o;
        Specification this$specification = this.getSpecification();
        Specification other$specification = other.getSpecification();
        if (this$specification == null ? other$specification != null : !((Object)this$specification).equals(other$specification)) {
            return false;
        }
        Implementation this$implementation = this.getImplementation();
        Implementation other$implementation = other.getImplementation();
        return !(this$implementation == null ? other$implementation != null : !((Object)this$implementation).equals(other$implementation));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Specification $specification = this.getSpecification();
        result = result * 59 + ($specification == null ? 43 : ((Object)$specification).hashCode());
        Implementation $implementation = this.getImplementation();
        result = result * 59 + ($implementation == null ? 43 : ((Object)$implementation).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VersionInfo(specification=" + this.getSpecification() + ", implementation=" + this.getImplementation() + ")";
    }
}

