/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.ftp.AbstractFtpClientWrapper;
import org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

class FtpClientWrapper
extends AbstractFtpClientWrapper {
    FtpClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions, Integer defaultTimeout) throws FileSystemException {
        super(root, fileSystemOptions, defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FTPClient createClient() throws FileSystemException {
        char[] password;
        char[] username;
        UserAuthenticationData authData;
        Map<String, String> mParams;
        GenericFileName rootName;
        block4: {
            FTPClient fTPClient;
            rootName = this.getRoot();
            mParams = null;
            if (rootName instanceof URLFileName) {
                mParams = this.getQueryParams((URLFileName)rootName);
            }
            authData = null;
            try {
                authData = UserAuthenticatorUtils.authenticate(this.getFileSystemOptions(), FtpFileProvider.AUTHENTICATOR_TYPES);
                username = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName()));
                password = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword()));
                if (mParams != null) break block4;
                fTPClient = FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), username, password, rootName.getPath(), this.getFileSystemOptions());
            }
            catch (Throwable throwable) {
                UserAuthenticatorUtils.cleanup(authData);
                throw throwable;
            }
            UserAuthenticatorUtils.cleanup(authData);
            return fTPClient;
        }
        FTPClient fTPClient = FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), username, password, rootName.getPath(), this.getFileSystemOptions(), mParams.get("proxyServer"), mParams.get("proxyPort"), mParams.get("proxyUsername"), mParams.get("proxyPassword"), mParams.get("timeout"), mParams.get("retryCount"));
        UserAuthenticatorUtils.cleanup(authData);
        return fTPClient;
    }

    private Map<String, String> getQueryParams(URLFileName urlFileName) {
        HashMap<String, String> mQueryParams = new HashMap<String, String>();
        String strQuery = urlFileName.getQueryString();
        if (strQuery != null && !strQuery.equals("")) {
            for (String strParam : strQuery.split("&")) {
                String[] arrParam = strParam.split("=");
                if (arrParam.length < 2) continue;
                mQueryParams.put(arrParam[0], arrParam[1]);
            }
        }
        return mQueryParams;
    }
}

