/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import java.io.File;
import java.util.Arrays;

public class IdentityInfo {
    private final File privateKey;
    private final File publicKey;
    private final byte[] passPhrase;

    public IdentityInfo(File privateKey) {
        this(privateKey, null, null);
    }

    public IdentityInfo(File privateKey, byte[] passPhrase) {
        this(privateKey, null, passPhrase);
    }

    public IdentityInfo(File privateKey, File publicKey, byte[] passPhrase) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.passPhrase = passPhrase;
    }

    public File getPrivateKey() {
        return this.privateKey;
    }

    public File getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public int hashCode() {
        Object[] identityData = new String[]{this.privateKey != null ? this.privateKey.getAbsolutePath() : null, this.publicKey != null ? this.publicKey.getAbsolutePath() : null, Arrays.toString(this.passPhrase)};
        return Arrays.hashCode(identityData);
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }
}

