/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class SftpClient {
    private ChannelSftp channel;
    private Session session;
    private FileSystemOptions fso;
    private GenericFileName rootName;

    public SftpClient(FileSystemOptions fileSystemOptions, GenericFileName rootName) throws FileSystemException {
        this.fso = fileSystemOptions;
        this.rootName = rootName;
        this.ensureSession();
    }

    public Channel getChannel(String type) throws FileSystemException, JSchException {
        this.ensureSession();
        Channel requestedChannel = this.session.openChannel(type);
        return requestedChannel;
    }

    public ChannelSftp getChannel() throws FileSystemException {
        block5: {
            this.ensureSession();
            if (this.channel == null || !this.channel.isConnected()) {
                try {
                    this.channel = (ChannelSftp)this.session.openChannel("sftp");
                    this.channel.connect();
                    Boolean userDirIsRoot = SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.fso);
                    String workingDirectory = this.rootName.getPath();
                    if (workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue()) break block5;
                    try {
                        this.channel.cd(workingDirectory);
                    }
                    catch (SftpException e) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", (Object)workingDirectory, (Throwable)e);
                    }
                }
                catch (JSchException | FileSystemException e) {
                    throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", e);
                }
            }
        }
        return this.channel;
    }

    public void close() {
        if (null != this.channel) {
            this.channel.disconnect();
            this.channel = null;
        }
        if (null != this.session) {
            this.session.disconnect();
            this.session = null;
        }
    }

    private void ensureSession() throws FileSystemException {
        block4: {
            Session session;
            if (this.session != null && this.session.isConnected()) break block4;
            this.close();
            UserAuthenticationData authData = null;
            try {
                authData = UserAuthenticatorUtils.authenticate(this.fso, SftpFileProvider.AUTHENTICATOR_TYPES);
                session = SftpClientFactory.createConnection(this.rootName.getHostName(), this.rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(this.rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(this.rootName.getPassword())), this.fso);
            }
            catch (Exception e) {
                try {
                    throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)this.fso, (Throwable)e);
                }
                catch (Throwable throwable) {
                    UserAuthenticatorUtils.cleanup(authData);
                    throw throwable;
                }
            }
            UserAuthenticatorUtils.cleanup(authData);
            this.session = session;
        }
    }
}

