/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp.test;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import junit.framework.Test;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.provider.ftp.test.FtpProviderTestCase;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;

public class FtpProviderUserDirTestCase
extends FtpProviderTestCase {
    public static Test suite() throws Exception {
        return FtpProviderUserDirTestCase.suite(new FtpProviderUserDirTestCase());
    }

    @Override
    protected boolean getUserDirIsRoot() {
        return true;
    }

    @Override
    protected FileSystemFactory getFtpFileSystem() throws IOException {
        File testDir = new File(FtpProviderUserDirTestCase.getTestDirectory());
        final File rootDir = new File(testDir, "homeDirIsRoot");
        File homesDir = new File(rootDir, "home");
        File initialDir = new File(homesDir, "test");
        FileUtils.deleteDirectory((File)rootDir);
        rootDir.mkdir();
        FileUtils.copyDirectory((File)testDir, (File)initialDir, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getPath().contains(rootDir.getName());
            }
        });
        return new NativeFileSystemFactory(){

            public FileSystemView createFileSystemView(User user) throws FtpException {
                FileSystemView fsView = super.createFileSystemView(user);
                fsView.changeWorkingDirectory("home/test");
                return fsView;
            }
        };
    }

    @Override
    protected String getFtpRootDir() {
        return new File(FtpProviderUserDirTestCase.getTestDirectory(), "homeDirIsRoot").getPath();
    }
}

