/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp.test;

import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Timestamp;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.ftp.test.FtpProviderTestCase;
import org.apache.ftpserver.ftplet.FtpException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ListChildrenFromEmptyFolderTest {
    @BeforeClass
    public static void setUpClass() throws FtpException, IOException {
        FtpProviderTestCase.setUpClass(FtpProviderTestCase.getTestDirectory(), null);
    }

    @AfterClass
    public static void tearDownClass() throws MalformedURLException, FtpException {
        FtpProviderTestCase.tearDownClass();
    }

    private FileObject resolveRoot() throws FileSystemException {
        return VFS.getManager().resolveFile(FtpProviderTestCase.getConnectionUri() + "/" + new Timestamp(System.currentTimeMillis()).getTime());
    }

    @Test
    public void testListChildren() throws IOException {
        FileObject rootDir = this.resolveRoot();
        Assert.assertTrue((!rootDir.exists() ? 1 : 0) != 0);
        rootDir.createFolder();
        Assert.assertTrue((boolean)rootDir.exists());
        Assert.assertSame((Object)FileType.FOLDER, (Object)rootDir.getType());
        try {
            Assert.assertEquals((long)0L, (long)rootDir.getChildren().length);
        }
        catch (FileNotFolderException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

