/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar.test;

import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.jar.test.JarProviderTestCase;
import org.junit.Assert;
import org.junit.Test;

public class JarAttributesTestCase {
    private void printAttributes(Map<String, Object> attributes) {
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            System.out.println("Key: " + e.getKey() + ", Value: " + e.getValue());
        }
    }

    @Test
    public void testAttributes() throws Exception {
        FileObject file = JarProviderTestCase.getTestJar(VFS.getManager(), "test.jar");
        Map attributes = file.getContent().getAttributes();
        Assert.assertEquals((Object)"1.0", attributes.get("Manifest-Version"));
    }

    @Test
    public void testNestedAttributes() throws Exception {
        FileObject nested = JarProviderTestCase.getTestJar(VFS.getManager(), "nested.jar");
        FileObject file = nested.resolveFile("test.jar");
        Map attributes = file.getContent().getAttributes();
        Assert.assertEquals((Object)"1.0", attributes.get("Manifest-Version"));
    }
}

