/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.OutputStream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;
import org.junit.Assert;

public class PermissionsTests
extends AbstractProviderTestCase {
    public static final String FILENAME = "permission.txt";

    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.READ_CONTENT, Capability.WRITE_CONTENT};
    }

    public void testExecutable() throws Exception {
        FileObject file = this.createTestFile();
        if (this.isWindows()) {
            Assert.assertTrue((boolean)file.isExecutable());
        } else {
            file.setExecutable(true, true);
            Assert.assertTrue((boolean)file.isExecutable());
            file.setExecutable(true, false);
            Assert.assertTrue((boolean)file.isExecutable());
        }
    }

    public void testWriteable() throws Exception {
        FileObject file = this.createTestFile();
        file.setWritable(true, true);
        Assert.assertTrue((boolean)file.isWriteable());
        file.setWritable(true, false);
        Assert.assertTrue((boolean)file.isWriteable());
    }

    public void testReadable() throws Exception {
        FileObject file = this.createTestFile();
        if (this.isWindows()) {
            Assert.assertTrue((boolean)file.isReadable());
        } else {
            file.setReadable(true, true);
            Assert.assertTrue((boolean)file.isReadable());
            file.setReadable(true, false);
            Assert.assertTrue((boolean)file.isReadable());
        }
    }

    protected void tearDown() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        FileObject file = scratchFolder.resolveFile(FILENAME);
        file.setWritable(true, true);
        file.delete();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject createTestFile() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        PermissionsTests.assertNotNull((Object)scratchFolder);
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        FileObject file = scratchFolder.resolveFile(FILENAME);
        PermissionsTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        return file;
    }

    private boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS && this.getFileSystem() instanceof LocalFileSystem;
    }
}

