/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.test;

import java.io.OutputStream;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class ProviderWriteAppendTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCaps() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT};
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppendContent() throws Exception {
        FileObject scratchFolder = this.createScratchFolder();
        FileObject file = scratchFolder.resolveFile("file1.txt");
        ProviderWriteAppendTests.assertTrue((!file.exists() ? 1 : 0) != 0);
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        String contentAppend = "Here is some sample content for the file.  Blah Blah Blah.Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.", file);
        try (OutputStream os2 = file.getContent().getOutputStream(true);){
            os2.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes("utf-8"));
        }
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.Here is some sample content for the file.  Blah Blah Blah.", file);
        FileObject fileCopy = scratchFolder.resolveFile("file1copy.txt");
        ProviderWriteAppendTests.assertTrue((!fileCopy.exists() ? 1 : 0) != 0);
        fileCopy.copyFrom(file, Selectors.SELECT_SELF);
        this.assertSameContent("Here is some sample content for the file.  Blah Blah Blah.Here is some sample content for the file.  Blah Blah Blah.", fileCopy);
        ProviderWriteAppendTests.assertTrue((boolean)fileCopy.exists());
        ProviderWriteAppendTests.assertTrue((boolean)fileCopy.delete());
    }
}

