/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;

public abstract class AbstractFtpClientWrapper
implements FtpClient {
    private static final Log LOG = LogFactory.getLog(AbstractFtpClientWrapper.class);
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private final Integer defaultTimeout;
    private FTPClient ftpClient;

    public AbstractFtpClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions, Integer defaultTimeout) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.defaultTimeout = defaultTimeout;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    protected Integer getDefaultTimeout() {
        return this.defaultTimeout;
    }

    protected abstract FTPClient createClient() throws FileSystemException;

    private synchronized FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        if (this.root.getURI().contains("vfs.passive=true") && this.ftpClient.getDataConnectionMode() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"FTP Client is entering into passive mode.");
            }
            this.ftpClient.enterLocalPassiveMode();
        }
        return this.ftpClient;
    }

    @Override
    public boolean isConnected() throws FileSystemException {
        return this.ftpClient != null && this.ftpClient.isConnected();
    }

    @Override
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    @Override
    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            return this.listFilesInDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.listFilesInDirectory(relPath);
        }
    }

    private FTPFile[] listFilesInDirectory(String relPath) throws IOException {
        FTPFile[] files = this.getFtpClient().listFiles(relPath);
        if (FTPReply.isPositiveCompletion((int)this.getFtpClient().getReplyCode())) {
            return files;
        }
        String workingDirectory = null;
        if (relPath != null) {
            workingDirectory = this.getFtpClient().printWorkingDirectory();
            if (!this.getFtpClient().changeWorkingDirectory(relPath)) {
                return null;
            }
        }
        files = this.getFtpClient().listFiles();
        if (relPath != null && !this.getFtpClient().changeWorkingDirectory(workingDirectory)) {
            throw new FileSystemException("vfs.provider.ftp.wrapper/change-work-directory-back.error", (Object)workingDirectory);
        }
        return files;
    }

    @Override
    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(relPath);
        }
    }

    @Override
    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpClient().deleteFile(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().deleteFile(relPath);
        }
    }

    @Override
    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpClient().rename(oldName, newName);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().rename(oldName, newName);
        }
    }

    @Override
    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(relPath);
        }
    }

    @Override
    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    @Override
    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(relPath);
        }
    }

    @Override
    public InputStream retrieveFileStream(String relPath, long restartOffset) throws IOException {
        try {
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPClient client = this.getFtpClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
    }

    @Override
    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(relPath);
        }
    }

    @Override
    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(relPath);
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    @Override
    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }
}

