/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.ClientWrapperFactory;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;

public class FtpFileSystem
extends AbstractFileSystem {
    private static final Log LOG = LogFactory.getLog(FtpFileSystem.class);
    private final AtomicReference<FtpClient> idleClient = new AtomicReference();
    private final ClientWrapperFactory clientWrapperFactory;
    private volatile boolean isFileSystemClosed = false;

    public FtpFileSystem(GenericFileName rootName, ClientWrapperFactory clientWrapperFactory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, null, fileSystemOptions);
        this.clientWrapperFactory = clientWrapperFactory;
        this.idleClient.set(clientWrapperFactory.create());
    }

    @Override
    protected void doCloseCommunicationLink() {
        this.isFileSystemClosed = true;
        FtpClient idle = this.idleClient.getAndSet(null);
        if (idle != null) {
            this.closeConnection(idle);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(FtpFileProvider.capabilities);
    }

    private void closeConnection(FtpClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (IOException e) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.ftp/close-connection.error", e);
        }
    }

    public FtpClient getClient() throws FileSystemException {
        FtpClient client = this.idleClient.getAndSet(null);
        if (client == null || !client.isConnected()) {
            client = this.clientWrapperFactory.create();
        }
        return client;
    }

    void putClient(FtpClient client) {
        if (this.isFileSystemClosed) {
            this.closeConnection(client);
        } else if (!this.idleClient.compareAndSet(null, client)) {
            this.closeConnection(client);
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new FtpFileObject(name, this, this.getRootName());
    }
}

