/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftps.FtpsClientWrapperFactory;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;

public class FtpsFileProvider
extends FtpFileProvider {
    public FtpsFileProvider() {
        this.setFileNameParser(HostFileNameParser.getInstance());
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        FtpsClientWrapperFactory wrapperFactory = new FtpsClientWrapperFactory(rootName, fileSystemOptions, this.defaultTimeout);
        return new FtpFileSystem(rootName, wrapperFactory, fileSystemOptions);
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return FtpsFileSystemConfigBuilder.getInstance();
    }
}

