/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.Map;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.UriParser;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    protected Integer defaultTimeout = null;
    private static final String CONNECT_TIMEOUT = "transport.vfs.ConnectTimeout";

    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        Integer timeout = null;
        Map<String, String> queryParam = UriParser.extractQueryParams(uri);
        String strConnectTimeout = queryParam.get(CONNECT_TIMEOUT);
        if (strConnectTimeout != null) {
            try {
                timeout = Integer.valueOf(strConnectTimeout);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().warn((Object)("value of transport.vfs.ConnectTimeout param " + strConnectTimeout + " is invalid so the time out does not applied"));
                timeout = null;
            }
        }
        try {
            name = this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", (Object)uri, (Throwable)exc);
        }
        return this.findFile(name, fileSystemOptions, timeout);
    }

    protected FileObject findFile(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.findFile(name, fileSystemOptions, null);
    }

    protected FileObject findFile(FileName name, FileSystemOptions fileSystemOptions, Integer defaultTimeout) throws FileSystemException {
        FileName rootName = this.getContext().getFileSystemManager().resolveName(name, "/");
        FileSystem fs = this.getFileSystem(rootName, fileSystemOptions, defaultTimeout);
        FileObject testFile = fs.resolveFile(name);
        try {
            testFile.exists();
        }
        catch (FileSystemException e) {
            ((DefaultFileSystemManager)this.getContext().getFileSystemManager()).closeCachedFileSystem(name.getURI(), fileSystemOptions);
            fs = this.getFileSystem(rootName, fileSystemOptions, defaultTimeout);
            testFile = fs.resolveFile(name);
        }
        return testFile;
    }

    protected synchronized FileSystem getFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.getFileSystem(rootName, fileSystemOptions, null);
    }

    protected synchronized FileSystem getFileSystem(FileName rootName, FileSystemOptions fileSystemOptions, Integer defaultTimeout) throws FileSystemException {
        this.defaultTimeout = defaultTimeout;
        FileSystem fs = this.findFileSystem(rootName, fileSystemOptions);
        if (fs == null) {
            fs = this.doCreateFileSystem(rootName, fileSystemOptions);
            this.addFileSystem(rootName, fs);
        }
        return fs;
    }

    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;
}

