/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Locale;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs2.SSLConnectionException;

public class FTPSClientWithSessionResumption
extends FTPSClient {
    public FTPSClientWithSessionResumption() {
    }

    public FTPSClientWithSessionResumption(boolean isImplicit) {
        super(isImplicit);
    }

    protected void _connectAction_() throws SSLConnectionException {
        try {
            super._connectAction_();
            this.execPBSZ(0L);
            this.execPROT("P");
        }
        catch (IOException e) {
            throw new SSLConnectionException("Error occurred while connecting to the server");
        }
    }

    protected void _prepareDataSocket_(Socket socket) throws SSLConnectionException {
        if (socket instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)this._socket_).getSession();
            if (session.isValid()) {
                SSLSessionContext context = session.getSessionContext();
                try {
                    Method getHostMethod;
                    Field sessionHostPortCache = context.getClass().getDeclaredField("sessionHostPortCache");
                    sessionHostPortCache.setAccessible(true);
                    Object cache = sessionHostPortCache.get(context);
                    Method putMethod = cache.getClass().getDeclaredMethod("put", Object.class, Object.class);
                    putMethod.setAccessible(true);
                    try {
                        getHostMethod = socket.getClass().getMethod("getPeerHost", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        getHostMethod = socket.getClass().getDeclaredMethod("getHost", new Class[0]);
                    }
                    getHostMethod.setAccessible(true);
                    Object peerHost = getHostMethod.invoke((Object)socket, new Object[0]);
                    InetAddress iAddr = socket.getInetAddress();
                    int port = socket.getPort();
                    putMethod.invoke(cache, String.format("%s:%s", peerHost, port).toLowerCase(Locale.ROOT), session);
                    putMethod.invoke(cache, String.format("%s:%s", iAddr.getHostName(), port).toLowerCase(Locale.ROOT), session);
                    putMethod.invoke(cache, String.format("%s:%s", iAddr.getHostAddress(), port).toLowerCase(Locale.ROOT), session);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    throw new SSLConnectionException("Error occurred while initializing the SSL Socket");
                }
            }
            throw new SSLConnectionException("Invalid SSL Session");
        }
    }
}

