/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs2.provider.ftps.FTPSClientWithSessionResumption;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsMode;

public final class FtpsClientFactory {
    private FtpsClientFactory() {
    }

    public static FTPSClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FtpsConnectionFactory factory = new FtpsConnectionFactory(FtpsFileSystemConfigBuilder.getInstance());
        return (FTPSClient)factory.createConnection(hostname, port, username, password, workingDirectory, fileSystemOptions);
    }

    private static final class FtpsConnectionFactory
    extends FtpClientFactory.ConnectionFactory<FTPSClient, FtpsFileSystemConfigBuilder> {
        private final Log log = LogFactory.getLog(this.getClass());

        private FtpsConnectionFactory(FtpsFileSystemConfigBuilder builder) {
            super(builder);
        }

        @Override
        protected FTPSClient createClient(FileSystemOptions fileSystemOptions) throws FileSystemException {
            KeyManager keyManager;
            FTPSClientWithSessionResumption client = ((FtpsFileSystemConfigBuilder)this.builder).getFtpsMode(fileSystemOptions) == FtpsMode.IMPLICIT ? new FTPSClientWithSessionResumption(true) : new FTPSClientWithSessionResumption();
            TrustManager trustManager = ((FtpsFileSystemConfigBuilder)this.builder).getTrustManager(fileSystemOptions);
            if (trustManager != null) {
                client.setTrustManager(trustManager);
            }
            if ((keyManager = ((FtpsFileSystemConfigBuilder)this.builder).getKeyManager(fileSystemOptions)) != null) {
                client.setKeyManager(keyManager);
            }
            return client;
        }

        @Override
        protected void preConfigureClient(FileSystemOptions fileSystemOptions) throws Exception {
            String KEYSTORE = ((FtpsFileSystemConfigBuilder)this.builder).getKeyStore(fileSystemOptions);
            String TRUSTSTORE = ((FtpsFileSystemConfigBuilder)this.builder).getTrustStore(fileSystemOptions);
            String KS_PASSWD = ((FtpsFileSystemConfigBuilder)this.builder).getKeyStorePW(fileSystemOptions);
            String TS_PASSWD = ((FtpsFileSystemConfigBuilder)this.builder).getTrustStorePW(fileSystemOptions);
            String KEY_PASSWD = ((FtpsFileSystemConfigBuilder)this.builder).getKeyPW(fileSystemOptions);
            KeyManagerFactory keyManagerFactory = null;
            TrustManagerFactory trustManagerFactory = null;
            try {
                if (KEYSTORE != null && !KEYSTORE.trim().isEmpty()) {
                    FileInputStream keystorePath = new FileInputStream(new File(KEYSTORE));
                    KeyStore keyStore = KeyStore.getInstance("jks");
                    keyStore.load(keystorePath, KS_PASSWD.toCharArray());
                    keystorePath.close();
                    keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, KEY_PASSWD.toCharArray());
                }
                if (TRUSTSTORE != null && !TRUSTSTORE.trim().isEmpty()) {
                    FileInputStream truststorePath = new FileInputStream(new File(TRUSTSTORE));
                    KeyStore trustStore = KeyStore.getInstance("jks");
                    trustStore.load(truststorePath, TS_PASSWD.toCharArray());
                    truststorePath.close();
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(trustStore);
                }
            }
            catch (KeyStoreException e) {
                this.log.error((Object)"Error occurred when initializing keystores", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                this.log.error((Object)"Error occurred while retrieving the keystore paths", (Throwable)e);
                throw e;
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((Object)"Error when getting the default algorithm", (Throwable)e);
                throw e;
            }
            catch (CertificateException e) {
                this.log.error((Object)"Certificate exception occurred when loading the KeyStores ", (Throwable)e);
                throw e;
            }
            catch (UnrecoverableKeyException e) {
                this.log.error((Object)"Unrecoverable Key exception occurred", (Throwable)e);
                throw e;
            }
        }

        @Override
        protected void setupOpenConnection(FTPSClient client, FileSystemOptions fileSystemOptions) throws IOException {
            FtpsDataChannelProtectionLevel level = ((FtpsFileSystemConfigBuilder)this.builder).getDataChannelProtectionLevel(fileSystemOptions);
            if (level != null) {
                try {
                    client.execPBSZ(0L);
                    client.execPROT(level.name());
                }
                catch (SSLException e) {
                    throw new FileSystemException("vfs.provider.ftps/data-channel.level", (Throwable)e, level.toString());
                }
            }
        }
    }
}

