/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.UriParser;

public class LocalFileName
extends AbstractFileName {
    private static final char[] RESERVED_URI_CHARS = new char[]{'#'};
    private final String rootFile;
    private String queryString;

    protected LocalFileName(String scheme, String rootFile, String path, FileType type) {
        super(scheme, path, type);
        this.rootFile = rootFile;
    }

    protected LocalFileName(String scheme, String rootFile, String path, FileType type, String queryString) {
        this(scheme, rootFile, path, type);
        this.queryString = queryString;
    }

    public String getRootFile() {
        return this.rootFile;
    }

    @Override
    public FileName createName(String path, FileType type) {
        return new LocalFileName(this.getScheme(), this.rootFile, path, type);
    }

    @Override
    public String getURI() {
        String uri = super.getURI();
        if (uri != null && uri.length() > 0) {
            try {
                uri = UriParser.decode(uri);
                uri = UriParser.encode(uri, RESERVED_URI_CHARS);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return uri;
    }

    @Override
    public String getFriendlyURI() {
        String uri = super.getFriendlyURI();
        if (uri != null && uri.length() > 0) {
            try {
                uri = UriParser.decode(uri);
                uri = UriParser.encode(uri, RESERVED_URI_CHARS);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return uri;
    }

    @Override
    protected String createURI() {
        if (this.queryString != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.createURI());
            sb.append("?");
            sb.append(this.queryString);
            return sb.toString();
        }
        return super.createURI();
    }

    @Override
    public String toString() {
        try {
            return UriParser.decode(super.getURI());
        }
        catch (FileSystemException e) {
            return super.getURI();
        }
    }

    @Override
    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        buffer.append(this.rootFile);
    }
}

