/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.sftp.SftpClient;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpRandomAccessContent;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.PosixPermissions;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class SftpFileObject
extends AbstractFileObject<SftpFileSystem> {
    private static final long MOD_TIME_FACTOR = 1000L;
    private SftpATTRS attrs;
    private final String relPath;
    private boolean inRefresh;

    protected SftpFileObject(AbstractFileName name, SftpFileSystem fileSystem) throws FileSystemException {
        super(name, fileSystem);
        this.relPath = UriParser.decode(fileSystem.getRootName().getRelativeName(name));
    }

    @Override
    protected void doDetach() throws Exception {
        this.attrs = null;
    }

    @Override
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                try {
                    this.attrs = null;
                    this.getType();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    @Override
    protected FileType doGetType() throws Exception {
        if (this.attrs == null) {
            this.statSelf();
        }
        if (this.attrs == null) {
            return FileType.IMAGINARY;
        }
        if ((this.attrs.getFlags() & 4) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-permissions.error");
        }
        if (this.attrs.isDir()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected void onChange() throws Exception {
        this.statSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statSelf() throws Exception {
        block10: {
            SftpClient sftpClient = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
            ChannelSftp channel = null;
            try {
                channel = sftpClient.getChannel();
                this.setStat(channel.stat(this.relPath));
            }
            catch (SftpException e) {
                try {
                    if (e.id != 2) {
                        channel.disconnect();
                        channel = sftpClient.getChannel();
                        this.setStat(channel.stat(this.relPath));
                    } else {
                        this.attrs = null;
                    }
                }
                catch (SftpException innerEx) {
                    if (innerEx.id == 2) {
                        this.attrs = null;
                        break block10;
                    }
                    throw innerEx;
                }
            }
            finally {
                ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
            }
        }
    }

    private void setStat(SftpATTRS attrs) {
        this.attrs = attrs;
    }

    @Override
    protected void doCreateFolder() throws Exception {
        SftpClient sftpClient = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ChannelSftp channel = sftpClient.getChannel();
            channel.mkdir(this.relPath);
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
        }
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 8) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-modtime.error");
        }
        return (long)this.attrs.getMTime() * 1000L;
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        int newMTime = (int)(modtime / 1000L);
        this.attrs.setACMODTIME(this.attrs.getATime(), newMTime);
        this.flushStat();
        return true;
    }

    private void flushStat() throws IOException, SftpException {
        SftpClient sftpClient = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ChannelSftp channel = sftpClient.getChannel();
            channel.setStat(this.relPath, this.attrs);
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
        }
    }

    @Override
    protected void doDelete() throws Exception {
        SftpClient sftpClient = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ChannelSftp channel = sftpClient.getChannel();
            if (this.isFile()) {
                channel.rm(this.relPath);
            } else {
                channel.rmdir(this.relPath);
            }
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRename(FileObject newFile) throws Exception {
        SftpClient sftpClient = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ChannelSftp channel = sftpClient.getChannel();
            SftpFileObject newSftpFileObject = (SftpFileObject)FileObjectUtils.getAbstractFileObject(newFile);
            channel.rename(this.relPath, newSftpFileObject.relPath);
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
        }
    }

    protected PosixPermissions getPermissions(boolean checkIds) throws Exception {
        this.statSelf();
        boolean isInGroup = false;
        if (checkIds) {
            for (int groupId : ((SftpFileSystem)this.getAbstractFileSystem()).getGroupsIds()) {
                if (groupId != this.attrs.getGId()) continue;
                isInGroup = true;
                break;
            }
        }
        boolean isOwner = checkIds ? this.attrs.getUId() == ((SftpFileSystem)this.getAbstractFileSystem()).getUId() : false;
        return new PosixPermissions(this.attrs.getPermissions(), isOwner, isInGroup);
    }

    @Override
    protected boolean doIsReadable() throws Exception {
        if (this.isPermissionCheckRequired()) {
            return this.getPermissions(true).isReadable();
        }
        return true;
    }

    private boolean isPermissionCheckRequired() throws Exception {
        String permissionCheck = SftpFileSystemConfigBuilder.getInstance().getAvoidPermissionCheck(((SftpFileSystem)this.getAbstractFileSystem()).getFileSystemOptions());
        return permissionCheck == null || !permissionCheck.equalsIgnoreCase("true");
    }

    @Override
    protected boolean doSetReadable(boolean readable, boolean ownerOnly) throws Exception {
        PosixPermissions permissions = this.getPermissions(false);
        int newPermissions = permissions.makeReadable(readable, ownerOnly);
        if (newPermissions == permissions.getPermissions()) {
            return true;
        }
        this.attrs.setPERMISSIONS(newPermissions);
        this.flushStat();
        return true;
    }

    @Override
    protected boolean doIsWriteable() throws Exception {
        if (this.isPermissionCheckRequired()) {
            return this.getPermissions(true).isWritable();
        }
        return true;
    }

    @Override
    protected boolean doSetWritable(boolean writable, boolean ownerOnly) throws Exception {
        PosixPermissions permissions = this.getPermissions(false);
        int newPermissions = permissions.makeWritable(writable, ownerOnly);
        if (newPermissions == permissions.getPermissions()) {
            return true;
        }
        this.attrs.setPERMISSIONS(newPermissions);
        this.flushStat();
        return true;
    }

    @Override
    protected boolean doIsExecutable() throws Exception {
        if (this.isPermissionCheckRequired()) {
            return this.getPermissions(true).isExecutable();
        }
        return true;
    }

    @Override
    protected boolean doSetExecutable(boolean executable, boolean ownerOnly) throws Exception {
        PosixPermissions permissions = this.getPermissions(false);
        int newPermissions = permissions.makeExecutable(executable, ownerOnly);
        if (newPermissions == permissions.getPermissions()) {
            return true;
        }
        this.attrs.setPERMISSIONS(newPermissions);
        this.flushStat();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject[] doListChildrenResolved() throws Exception {
        if (this.isFile()) {
            return null;
        }
        Vector vector = null;
        SftpClient sftpClient = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
        ChannelSftp channel = null;
        try {
            channel = sftpClient.getChannel();
            vector = channel.ls(this.relPath);
        }
        catch (SftpException e) {
            String workingDirectory = null;
            try {
                if (channel != null && this.relPath != null) {
                    workingDirectory = channel.pwd();
                    channel.cd(this.relPath);
                }
            }
            catch (SftpException ex) {
                FileObject[] fileObjectArray = null;
                return fileObjectArray;
            }
            SftpException lsEx = null;
            try {
                vector = channel.ls(".");
            }
            catch (SftpException ex) {
                lsEx = ex;
            }
            finally {
                try {
                    if (this.relPath != null) {
                        channel.cd(workingDirectory);
                    }
                }
                catch (SftpException xe) {
                    throw new FileSystemException("vfs.provider.sftp/change-work-directory-back.error", (Object)workingDirectory, (Throwable)lsEx);
                }
            }
            if (lsEx != null) {
                throw lsEx;
            }
        }
        finally {
            ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
        }
        if (vector == null) {
            throw new FileSystemException("vfs.provider.sftp/list-children.error");
        }
        ArrayList<FileObject> children = new ArrayList<FileObject>();
        for (ChannelSftp.LsEntry stat : vector) {
            String name = stat.getFilename();
            if (VFS.isUriStyle() && stat.getAttrs().isDir() && name.charAt(name.length() - 1) != '/') {
                name = name + "/";
            }
            if (name.equals(".") || name.equals("..") || name.equals("./") || name.equals("../")) continue;
            FileObject fo = this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), UriParser.encode(name), NameScope.CHILD));
            ((SftpFileObject)FileObjectUtils.getAbstractFileObject(fo)).setStat(stat.getAttrs());
            children.add(fo);
        }
        return children.toArray(new FileObject[children.size()]);
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return null;
    }

    @Override
    protected long doGetContentSize() throws Exception {
        if (this.attrs == null || (this.attrs.getFlags() & 1) == 0) {
            throw new FileSystemException("vfs.provider.sftp/unknown-size.error");
        }
        return this.attrs.getSize();
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new SftpRandomAccessContent(this, mode);
    }

    InputStream getInputStream(long filePointer) throws IOException {
        SftpClient sftpClient = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ChannelSftp channel = sftpClient.getChannel();
            InputStream is = channel.get(this.getName().getPathDecoded(), null, filePointer);
            return new SftpInputStream(sftpClient, is);
        }
        catch (SftpException e) {
            ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
            throw new FileSystemException(e);
        }
        catch (Exception e) {
            ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream doGetInputStream() throws Exception {
        SftpFileSystem sftpFileSystem = (SftpFileSystem)this.getAbstractFileSystem();
        synchronized (sftpFileSystem) {
            InputStream is;
            SftpClient client = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
            try {
                ChannelSftp channel = client.getChannel();
                if (!this.getType().hasContent()) {
                    ((SftpFileSystem)this.getAbstractFileSystem()).putClient(client);
                    throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
                }
                is = channel.get(this.relPath);
            }
            catch (SftpException e) {
                if (e.id == 2) {
                    ((SftpFileSystem)this.getAbstractFileSystem()).putClient(client);
                    throw new FileNotFoundException(this.getName());
                }
                ((SftpFileSystem)this.getAbstractFileSystem()).putClient(client);
                throw new FileSystemException(e);
            }
            catch (Exception e) {
                ((SftpFileSystem)this.getAbstractFileSystem()).putClient(client);
                throw e;
            }
            return new SftpInputStream(client, is);
        }
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        SftpOutputStream outputStream;
        SftpClient sftpClient = ((SftpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ChannelSftp channel = sftpClient.getChannel();
            outputStream = new SftpOutputStream(sftpClient, channel.put(this.relPath));
        }
        catch (Exception e) {
            ((SftpFileSystem)this.getAbstractFileSystem()).putClient(sftpClient);
            throw e;
        }
        return outputStream;
    }

    private class SftpOutputStream
    extends MonitorOutputStream {
        private final SftpClient sftpClient;

        public SftpOutputStream(SftpClient sftpClient, OutputStream out) throws FileSystemException {
            super(out);
            this.sftpClient = sftpClient;
        }

        @Override
        protected void onClose() throws IOException {
            ((SftpFileSystem)SftpFileObject.this.getAbstractFileSystem()).putClient(this.sftpClient);
        }
    }

    private class SftpInputStream
    extends MonitorInputStream {
        private final SftpClient client;

        public SftpInputStream(SftpClient client, InputStream in) throws FileSystemException {
            super(in);
            this.client = client;
        }

        @Override
        protected void onClose() throws IOException {
            ((SftpFileSystem)SftpFileObject.this.getAbstractFileSystem()).putClient(this.client);
        }
    }
}

