/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpClient;
import org.apache.commons.vfs2.provider.sftp.SftpFileObject;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;

public class SftpFileSystem
extends AbstractFileSystem {
    private static final int SLEEP_MILLIS = 100;
    private static final int EXEC_BUFFER_SIZE = 128;
    private static final long LAST_MOD_TIME_ACCURACY = 1000L;
    AtomicReference<SftpClient> sftpClientAtomicReference = new AtomicReference();
    private volatile boolean isFileSystemClosed;
    private int uid = -1;
    private int[] groupsIds;

    protected SftpFileSystem(GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, null, fileSystemOptions);
        this.sftpClientAtomicReference.set(new SftpClient(fileSystemOptions, rootName));
    }

    @Override
    protected void doCloseCommunicationLink() {
        this.isFileSystemClosed = true;
        SftpClient existingSftpClient = this.sftpClientAtomicReference.getAndSet(null);
        if (existingSftpClient != null) {
            existingSftpClient.close();
        }
    }

    protected synchronized SftpClient getClient() throws IOException {
        SftpClient existingSftpClient = this.sftpClientAtomicReference.getAndSet(null);
        if (existingSftpClient == null) {
            existingSftpClient = new SftpClient(this.getFileSystemOptions(), (GenericFileName)this.getRootName());
        }
        return existingSftpClient;
    }

    protected void putClient(SftpClient sftpClient) {
        if (this.isFileSystemClosed) {
            sftpClient.close();
        } else if (!this.sftpClientAtomicReference.compareAndSet(null, sftpClient)) {
            sftpClient.close();
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(SftpFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new SftpFileObject(name, this);
    }

    @Override
    public double getLastModTimeAccuracy() {
        return 1000.0;
    }

    public int[] getGroupsIds() throws JSchException, IOException {
        if (this.groupsIds == null) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommand("id -G", output);
            if (code != 0) {
                throw new JSchException("Could not get the groups id of the current user (error code: " + code + ")");
            }
            String[] groups = output.toString().trim().split("\\s+");
            int[] groupsIds = new int[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                groupsIds[i] = Integer.parseInt(groups[i]);
            }
            this.groupsIds = groupsIds;
        }
        return this.groupsIds;
    }

    public int getUId() throws JSchException, IOException {
        if (this.uid < 0) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommand("id -u", output);
            if (code != 0) {
                throw new FileSystemException("Could not get the user id of the current user (error code: " + code + ")");
            }
            this.uid = Integer.parseInt(output.toString().trim());
        }
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommand(String command, StringBuilder output) throws JSchException, IOException {
        SftpClient sftpClient = this.getClient();
        try {
            ChannelExec channel = (ChannelExec)sftpClient.getChannel("exec");
            channel.setCommand(command);
            channel.setInputStream(null);
            try (InputStreamReader stream = new InputStreamReader(channel.getInputStream());){
                int read;
                channel.setErrStream((OutputStream)System.err, true);
                channel.connect();
                char[] buffer = new char[128];
                while ((read = stream.read(buffer, 0, buffer.length)) >= 0) {
                    output.append(buffer, 0, read);
                }
            }
            while (!channel.isClosed()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            channel.disconnect();
            int n = channel.getExitStatus();
            return n;
        }
        finally {
            this.putClient(sftpClient);
        }
    }
}

