/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.util.Objects;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.osgi.framework.BundleContext;

public class JdkHandler
extends Handler {
    private static final String FQCN = Logger.class.getName();
    private static final String TLS_DEBUG_LOGGER = "javax.net.ssl";
    private static final String NO_LOGGING_MODE = "no_logging";
    private static final String DEBUG_LOGGING_MODE = "debug_logging";
    private static final String HEX_DUMP_OFFSET = "0000:";
    private final PaxLoggingManager m_loggingManager;
    private BundleContext bundleContext;
    private boolean synchronizedFormatter = false;

    public JdkHandler(PaxLoggingManager loggingManager) {
        this.m_loggingManager = loggingManager;
        this.setFormatter(new SimpleFormatter());
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        String sync = OsgiUtil.systemOrContextProperty(bundleContext, "org.ops4j.pax.logging.syncJULFormatter");
        this.synchronizedFormatter = sync == null || "true".equalsIgnoreCase(sync.trim());
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public Formatter getFormatter() {
        if (this.synchronizedFormatter) {
            return super.getFormatter();
        }
        return new SimpleFormatter();
    }

    @Override
    public void publish(LogRecord record) {
        String message;
        Level level = record.getLevel();
        String loggerName = record.getLoggerName();
        PaxLogger logger = this.m_loggingManager.getLogger(loggerName, FQCN);
        if (TLS_DEBUG_LOGGER.equals(loggerName) && !this.isTLSDebugLoggingEnabled()) {
            return;
        }
        try {
            message = TLS_DEBUG_LOGGER.equals(loggerName) && this.isTLSDebugLoggingEnabled() ? this.getTLSLogMessage(record) : this.getFormatter().formatMessage(record);
        }
        catch (Exception ex) {
            message = record.getMessage();
        }
        Throwable throwable = record.getThrown();
        int levelInt = level.intValue();
        if (throwable != null) {
            if (levelInt <= Level.FINER.intValue()) {
                logger.trace(message, (Object)throwable);
            } else if (levelInt <= Level.FINE.intValue()) {
                logger.debug(message, (Object)throwable);
            } else if (levelInt <= Level.INFO.intValue()) {
                logger.info(message, (Object)throwable);
            } else if (levelInt <= Level.WARNING.intValue()) {
                logger.warn(message, (Object)throwable);
            } else {
                logger.error(message, (Object)throwable);
            }
        } else if (levelInt <= Level.FINER.intValue()) {
            logger.trace(message);
        } else if (levelInt <= Level.FINE.intValue()) {
            logger.debug(message);
        } else if (levelInt <= Level.INFO.intValue()) {
            logger.info(message);
        } else if (levelInt <= Level.WARNING.intValue()) {
            logger.warn(message);
        } else {
            logger.error(message);
        }
    }

    private String getTLSLogMessage(LogRecord logRecord) {
        String message;
        try {
            message = logRecord.getMessage();
            if (logRecord.getParameters() != null) {
                String tlsLoggingModeProperty = System.getProperty("org.ops4j.pax.logging.tlsdebug.loggingMode");
                boolean isDebugLoggingEnabled = DEBUG_LOGGING_MODE.equals(tlsLoggingModeProperty);
                String logParameters = Stream.of(logRecord.getParameters()).filter(Objects::nonNull).filter(String.class::isInstance).map(String::valueOf).filter(x -> !this.isHexDumpMessage((String)x) || isDebugLoggingEnabled).collect(Collectors.joining(System.lineSeparator()));
                logParameters = !logParameters.trim().isEmpty() ? System.lineSeparator() + logParameters : "";
                message = message + logParameters;
            }
        }
        catch (Exception ex) {
            message = logRecord.getMessage();
        }
        return message;
    }

    private boolean isTLSDebugLoggingEnabled() {
        String property = System.getProperty("org.ops4j.pax.logging.tlsdebug.loggingMode");
        return property != null && !property.trim().isEmpty() && !NO_LOGGING_MODE.equals(property);
    }

    private boolean isHexDumpMessage(String message) {
        return message.startsWith(HEX_DUMP_OFFSET, 2);
    }
}

