/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.identity.oauth2.grant.mobile;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.ResponseHeader;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class MobileGrant
extends AbstractAuthorizationGrantHandler {
    private static Log log = LogFactory.getLog(MobileGrant.class);
    public static final String MOBILE_GRANT_PARAM = "mobileNumber";

    public boolean validateGrant(OAuthTokenReqMessageContext oAuthTokenReqMessageContext) throws IdentityOAuth2Exception {
        log.info((Object)"Mobile Grant handler is hit");
        boolean authStatus = false;
        RequestParameter[] parameters = oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getRequestParameters();
        String mobileNumber = null;
        for (RequestParameter parameter : parameters) {
            if (!MOBILE_GRANT_PARAM.equals(parameter.getKey()) || parameter.getValue() == null || parameter.getValue().length <= 0) continue;
            mobileNumber = parameter.getValue()[0];
        }
        if (mobileNumber != null) {
            authStatus = this.isValidMobileNumber(mobileNumber);
            if (authStatus) {
                String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername(mobileNumber);
                AuthenticatedUser mobileUser = AuthenticatedUser.createLocalAuthenticatedUserFromSubjectIdentifier((String)tenantAwareUsername);
                oAuthTokenReqMessageContext.setAuthorizedUser(mobileUser);
                oAuthTokenReqMessageContext.setScope(oAuthTokenReqMessageContext.getOauth2AccessTokenReqDTO().getScope());
            } else {
                ResponseHeader responseHeader = new ResponseHeader();
                responseHeader.setKey("SampleHeader-999");
                responseHeader.setValue("Provided Mobile Number is Invalid.");
                oAuthTokenReqMessageContext.addProperty((Object)"RESPONSE_HEADERS", (Object)new ResponseHeader[]{responseHeader});
            }
        }
        return authStatus;
    }

    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
        tokenRespDTO.setExpiresIn(tokReqMsgCtx.getAccessTokenIssuedTime() + 10000L);
        tokenRespDTO.setAccessToken(UUID.randomUUID().toString());
        tokenRespDTO.setRefreshToken(UUID.randomUUID().toString());
        tokenRespDTO.setTokenType("mobile");
        return tokenRespDTO;
    }

    public boolean authorizeAccessDelegation(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        return true;
    }

    public boolean validateScope(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        return true;
    }

    private boolean isValidMobileNumber(String mobileNumber) {
        return mobileNumber.startsWith("033");
    }

    public boolean isOfTypeApplicationUser() throws IdentityOAuth2Exception {
        return true;
    }
}

