/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.remoteum.sample;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.log4j.Logger;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.um.ws.api.WSAuthorizationManager;
import org.wso2.carbon.um.ws.api.WSUserStoreManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.remoteum.sample.RemoteUMSampleConstants;

public class RemoteUMClient {
    static Logger log = Logger.getLogger(RemoteUMClient.class);
    private static String serverUrl;
    private static String username;
    private static String password;
    private static String truststore;
    private static String truststorePassword;
    private AuthenticationAdminStub authstub = null;
    private ConfigurationContext ctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
    private String authCookie = null;
    private WSUserStoreManager remoteUserStoreManager = null;
    private WSAuthorizationManager remoteAuthorizationManager = null;

    public RemoteUMClient() throws Exception {
        String authEPR = serverUrl + "AuthenticationAdmin";
        this.authstub = new AuthenticationAdminStub(this.ctx, authEPR);
        ServiceClient client = this.authstub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)this.authCookie);
        System.setProperty("javax.net.ssl.trustStore", truststore);
        System.setProperty("javax.net.ssl.trustStorePassword", truststorePassword);
        this.login(username, password);
        this.createRemoteUserStoreManager();
    }

    public String login(String username, String password) throws Exception {
        boolean loggedIn = this.authstub.login(username, password, "localhost");
        if (loggedIn) {
            log.info((Object)"==================================================");
            log.info((Object)("The user " + username + " logged in successfully."));
            log.info((Object)"==================================================");
            this.authCookie = (String)this.authstub._getServiceClient().getServiceContext().getProperty("Cookie");
        } else {
            log.error((Object)("Error logging in " + username));
        }
        return this.authCookie;
    }

    public void createRemoteUserStoreManager() throws UserStoreException {
        this.remoteUserStoreManager = new WSUserStoreManager(serverUrl, this.authCookie, this.ctx);
    }

    public void createRemoteAuthorizationManager() throws UserStoreException {
        this.remoteAuthorizationManager = new WSAuthorizationManager(serverUrl, this.authCookie, this.ctx);
    }

    public void addUser(String userName, String password) throws UserStoreException {
        this.remoteUserStoreManager.addUser(userName, (Object)password, null, null, null);
        log.info((Object)("Added user: " + userName));
        log.info((Object)"================================================================");
    }

    public void addRole(String roleName) throws UserStoreException {
        this.remoteUserStoreManager.addRole(roleName, null, null);
        log.info((Object)("Added role: " + roleName));
        log.info((Object)"================================================================");
    }

    public void addUserWithRole(String userName, String password, String roleName) throws UserStoreException {
        this.remoteUserStoreManager.addUser(userName, (Object)password, new String[]{roleName}, null, null);
        log.info((Object)("Added user: " + userName + " with role: " + roleName));
        log.info((Object)"================================================================");
    }

    public String[] listUsers() throws UserStoreException {
        return this.remoteUserStoreManager.listUsers("*", -1);
    }

    public void deleteUser(String userName) throws UserStoreException {
        this.remoteUserStoreManager.deleteUser(userName);
        log.info((Object)("Deleted user:" + userName));
        log.info((Object)"================================================================");
    }

    public void deleteRole(String roleName) throws UserStoreException {
        this.remoteUserStoreManager.deleteRole(roleName);
        log.info((Object)("Deleted role:" + roleName));
        log.info((Object)"================================================================");
    }

    public void authorizeRole(String roleName, String resourceId, String action) throws UserStoreException {
        this.remoteAuthorizationManager.authorizeRole(roleName, resourceId, action);
    }

    public boolean isUserAuthorized(String userName, String resourceId, String action) throws UserStoreException {
        return this.remoteAuthorizationManager.isUserAuthorized(userName, resourceId, action);
    }

    public static void main(String[] args) throws Exception {
        RemoteUMClient.loadConfiguration();
        RemoteUMClient remoteUMClient = new RemoteUMClient();
        remoteUMClient.createRemoteUserStoreManager();
        RemoteUMClient.cleanSystem(remoteUMClient);
        remoteUMClient.addUser("kamal", "kamal");
        remoteUMClient.addRole("eng");
        remoteUMClient.addUserWithRole("saman", "saman", "eng");
        String[] users = remoteUMClient.listUsers();
        log.info((Object)"List of users in the system:");
        for (String user : users) {
            log.info((Object)user);
        }
        log.info((Object)"================================================================");
        remoteUMClient.deleteUser("kamal");
        String[] userList = remoteUMClient.listUsers();
        log.info((Object)"List of users in the system currently:");
        for (String user : userList) {
            log.info((Object)user);
        }
        log.info((Object)"================================================================");
        remoteUMClient.addUser("dinuka", "dinuka");
        remoteUMClient.getUserClaims("admin", "null");
        remoteUMClient.updateLastName("dinuka", "malalanayake");
        remoteUMClient.updateEmail("dinuka", "dinukam@wso2.com");
        remoteUMClient.createRemoteAuthorizationManager();
        remoteUMClient.authorizeRole("eng", "foo/bar", "read");
        if (remoteUMClient.isUserAuthorized("saman", "foo/bar", "read")) {
            log.info((Object)"User saman is authorized to read foo/bar.");
            log.info((Object)"================================================================");
        }
        RemoteUMClient.cleanSystem(remoteUMClient);
    }

    private static void cleanSystem(RemoteUMClient remoteUMClient) {
        try {
            remoteUMClient.deleteUser("kamal");
        }
        catch (UserStoreException userStoreException) {
            // empty catch block
        }
        try {
            remoteUMClient.deleteUser("dinuka");
        }
        catch (UserStoreException userStoreException) {
            // empty catch block
        }
        try {
            remoteUMClient.deleteUser("saman");
        }
        catch (UserStoreException userStoreException) {
            // empty catch block
        }
        try {
            remoteUMClient.deleteRole("eng");
        }
        catch (UserStoreException userStoreException) {
            // empty catch block
        }
    }

    public void getUserClaims(String username, String profile) throws Exception {
        log.info((Object)("================Print All Claims of " + username + "================"));
        for (Claim claims : this.remoteUserStoreManager.getUserClaimValues(username, profile)) {
            log.info((Object)"-----------------------------------");
            log.info((Object)(claims.getClaimUri() + " -- " + claims.getValue()));
        }
        log.info((Object)"================================================================");
    }

    public void updateLastName(String username, String value) throws Exception {
        this.remoteUserStoreManager.setUserClaimValue(username, "http://wso2.org/claims/lastname", value, null);
        log.info((Object)("lastname :" + value + " updated successful for User :" + username));
        log.info((Object)"================================================================");
    }

    public void updateEmail(String username, String value) throws Exception {
        this.remoteUserStoreManager.setUserClaimValue(username, "email", value, null);
        log.info((Object)("email :" + value + " updated successful for User :" + username));
        log.info((Object)"================================================================");
    }

    private static void loadConfiguration() throws IOException {
        Properties properties = new Properties();
        FileInputStream freader = new FileInputStream("client.properties");
        properties.load(freader);
        serverUrl = properties.getProperty("remote.server.url");
        username = properties.getProperty("user.name");
        password = properties.getProperty("user.password");
        truststore = RemoteUMSampleConstants.RESOURCE_PATH + properties.getProperty("truststore.path");
        truststorePassword = properties.getProperty("truststore.password");
    }
}

