/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.jks;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class JKSLoader
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(JKSLoader.class.getName());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        InputStream jksInputStream = this.getClass().getClassLoader().getResourceAsStream("jks.properties");
        if (jksInputStream == null) {
            LOGGER.log(Level.SEVERE, "jks.properties not found. Trust store properties will not be set.");
            return;
        }
        Properties jksProperties = new Properties();
        try {
            jksProperties.load(jksInputStream);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while loading properties.", e);
            return;
        }
        URL resource = this.getClass().getClassLoader().getResource(jksProperties.getProperty("keystorename"));
        if (resource != null) {
            LOGGER.log(Level.INFO, "Setting trust store path to : " + resource.getPath());
            System.setProperty("javax.net.ssl.trustStore", resource.getPath());
            System.setProperty("javax.net.ssl.trustStorePassword", jksProperties.getProperty("keystorepassword"));
        } else {
            LOGGER.log(Level.INFO, "Unable to find JKS defined by properties. Trust store properties will not be set.");
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

