/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.samples.oauth;

import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.client.authn.oauth.GoogleOAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthHmacSha1Signer;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.client.authn.oauth.OAuthUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceStub;
import org.wso2.carbon.identity.oauth.stub.OAuthServiceStub;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth.stub.types.Parameters;

public class OAuthServiceClient {
    private String username;
    private String password;
    private String backendServerURL;
    private ConfigurationContext configCtx;
    private Parameters params = new Parameters();
    private String consumerSecret;

    public OAuthServiceClient(String backendServerURL, ConfigurationContext configCtx, String username, String password) {
        this.backendServerURL = backendServerURL;
        this.configCtx = configCtx;
        this.username = username;
        this.password = password;
    }

    public void registerOAuthApplicationData(String applicationName, String oauthVersion, String consumerKey, String consumerSecret) throws Exception {
        if (consumerKey == null) {
            consumerKey = this.getRandomNumber();
        }
        if (consumerSecret == null) {
            consumerSecret = this.getRandomNumber();
        }
        if (oauthVersion == null) {
            oauthVersion = "OAuth-1.0a";
        }
        this.params.setAppName(applicationName);
        this.params.setVersion(oauthVersion);
        this.params.setOauthConsumerKey(consumerKey);
        this.consumerSecret = consumerSecret;
        String serviceURL = null;
        ServiceClient client = null;
        Options option = null;
        OAuthAdminServiceStub oauth = null;
        serviceURL = this.backendServerURL + "services/OAuthAdminService";
        oauth = new OAuthAdminServiceStub(this.configCtx, serviceURL);
        client = oauth._getServiceClient();
        option = client.getOptions();
        option.setManageSession(true);
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername(this.username);
        authenticator.setPassword(this.password);
        authenticator.setPreemptiveAuthentication(true);
        option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        OAuthConsumerAppDTO consumerApp = new OAuthConsumerAppDTO();
        consumerApp.setApplicationName(applicationName);
        consumerApp.setOAuthVersion(oauthVersion);
        consumerApp.setOauthConsumerKey(consumerKey);
        consumerApp.setOauthConsumerSecret(consumerSecret);
        oauth.registerOAuthApplicationData(consumerApp);
        System.out.println(applicationName + " registered as OAuth-1.0a application. Consumer Key: " + consumerKey + " and Consumer Secret " + consumerSecret + ".\n");
    }

    public void getRequestToken(String scope) throws Exception {
        if (scope != null) {
            this.params.setScope(scope);
        }
        Service.GDataRequest request = null;
        GoogleOAuthParameters oauthParameters = new GoogleOAuthParameters();
        oauthParameters.setOAuthConsumerKey(this.params.getOauthConsumerKey());
        oauthParameters.setOAuthConsumerSecret(this.consumerSecret);
        oauthParameters.setOAuthType(OAuthParameters.OAuthType.TWO_LEGGED_OAUTH);
        OAuthHmacSha1Signer signer = new OAuthHmacSha1Signer();
        GoogleService service = new GoogleService(this.params.getAppName(), this.params.getAppName());
        service.setOAuthCredentials((OAuthParameters)oauthParameters, (OAuthSigner)signer);
        String baseString = this.backendServerURL + "oauth/request-token";
        if (scope != null) {
            baseString = baseString + "?scope=" + scope;
        }
        URL feedUrl = new URL(baseString);
        request = service.createFeedRequest(feedUrl);
        request.execute();
        Parameters params = this.populateOauthConsumerData(OAuthServiceClient.convertStreamToString(request.getResponseStream()));
        if (params.getOauthToken() == null || params.getOauthTokenSecret() == null) {
            throw new Exception("");
        }
        this.params.setOauthToken(params.getOauthToken());
        this.params.setOauthTokenSecret(params.getOauthTokenSecret());
        System.out.println("Request token granted for " + this.params.getAppName() + ". Request token: " + params.getOauthToken() + " and Request token secret: " + params.getOauthTokenSecret() + ".\n");
    }

    public void authorizeRequestToken(String authorizedUser, String authorizedUserPassword) throws Exception {
        if (authorizedUser == null) {
            authorizedUser = this.username;
        }
        if (authorizedUserPassword == null) {
            authorizedUserPassword = this.password;
        }
        this.params.setAuthorizedbyUserName(authorizedUser);
        this.params.setAuthorizedbyUserPassword(authorizedUserPassword);
        String serviceURL = null;
        ServiceClient client = null;
        Options option = null;
        OAuthServiceStub oauth = null;
        serviceURL = this.backendServerURL + "services/OAuthService";
        oauth = new OAuthServiceStub(this.configCtx, serviceURL);
        client = oauth._getServiceClient();
        option = client.getOptions();
        option.setManageSession(true);
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername(this.username);
        authenticator.setPassword(this.password);
        authenticator.setPreemptiveAuthentication(true);
        option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        Parameters params = new Parameters();
        params.setOauthConsumerKey(this.params.getOauthConsumerKey());
        params.setOauthToken(this.params.getOauthToken());
        params.setAuthorizedbyUserName(authorizedUser);
        params.setAuthorizedbyUserPassword(authorizedUserPassword);
        Parameters respParams = oauth.authorizeOauthRequestToken(params);
        if (respParams.getOauthTokenVerifier() == null) {
            throw new Exception("");
        }
        this.params.setOauthTokenVerifier(respParams.getOauthTokenVerifier());
        System.out.println(this.params.getAppName() + " with request token " + this.params.getOauthToken() + " has been authorized by " + authorizedUser + ". Token verifier : " + respParams.getOauthTokenVerifier() + ".\n");
    }

    public void getAccessToken() throws Exception {
        Service.GDataRequest request = null;
        GoogleOAuthParameters oauthParameters = new GoogleOAuthParameters();
        oauthParameters.setOAuthConsumerKey(this.params.getOauthConsumerKey());
        oauthParameters.setOAuthConsumerSecret(this.consumerSecret);
        oauthParameters.setOAuthToken(this.params.getOauthToken());
        oauthParameters.setOAuthTokenSecret(this.params.getOauthTokenSecret());
        oauthParameters.setOAuthVerifier(this.params.getOauthTokenVerifier());
        OAuthHmacSha1Signer signer = new OAuthHmacSha1Signer();
        GoogleService service = new GoogleService(this.params.getAppName(), this.params.getAppName());
        service.setOAuthCredentials((OAuthParameters)oauthParameters, (OAuthSigner)signer);
        String baseString = this.backendServerURL + "oauth/access-token";
        URL feedUrl = new URL(baseString);
        request = service.createFeedRequest(feedUrl);
        request.execute();
        Parameters params = this.populateOauthConsumerData(OAuthServiceClient.convertStreamToString(request.getResponseStream()));
        if (params.getOauthToken() == null || params.getOauthTokenSecret() == null) {
            throw new Exception("");
        }
        this.params.setOauthToken(params.getOauthToken());
        this.params.setOauthTokenSecret(params.getOauthTokenSecret());
        System.out.println("Access token granted for " + this.params.getAppName() + " with authorized request token " + this.params.getOauthToken() + " and token verifier " + this.params.getOauthTokenVerifier() + ". Access token: " + params.getOauthToken() + " and access token secret " + params.getOauthTokenSecret() + ".\n");
    }

    public boolean validateAuthenticationRequest(String resourceURL) throws Exception {
        String serviceURL = null;
        ServiceClient client = null;
        Options option = null;
        OAuthServiceStub oauth = null;
        serviceURL = this.backendServerURL + "services/OAuthService";
        oauth = new OAuthServiceStub(this.configCtx, serviceURL);
        client = oauth._getServiceClient();
        option = client.getOptions();
        option.setManageSession(true);
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        authenticator.setUsername(this.username);
        authenticator.setPassword(this.password);
        authenticator.setPreemptiveAuthentication(true);
        option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        OAuthHmacSha1Signer signer = new OAuthHmacSha1Signer();
        GoogleOAuthParameters oauthParameters = new GoogleOAuthParameters();
        oauthParameters.setOAuthConsumerKey(this.params.getOauthConsumerKey());
        oauthParameters.setOAuthConsumerSecret(this.consumerSecret);
        oauthParameters.setOAuthToken(this.params.getOauthToken());
        oauthParameters.setOAuthTokenSecret(this.params.getOauthTokenSecret());
        oauthParameters.setOAuthVerifier(this.params.getOauthTokenVerifier());
        oauthParameters.setOAuthTimestamp(OAuthUtil.getTimestamp());
        oauthParameters.setOAuthNonce(OAuthUtil.getNonce());
        oauthParameters.setOAuthSignatureMethod("HMAC-SHA1");
        String baseString = OAuthUtil.getSignatureBaseString((String)resourceURL, (String)"GET", (Map)oauthParameters.getBaseParameters());
        String signature = signer.getSignature(baseString, (OAuthParameters)oauthParameters);
        Parameters params = new Parameters();
        params.setOauthConsumerKey(this.params.getOauthConsumerKey());
        params.setOauthToken(this.params.getOauthToken());
        params.setOauthTokenVerifier(this.params.getOauthTokenVerifier());
        params.setScope(this.params.getScope());
        params.setOauthTimeStamp(oauthParameters.getOAuthTimestamp());
        params.setOauthNonce(oauthParameters.getOAuthNonce());
        params.setVersion(this.params.getVersion());
        params.setOauthSignatureMethod(oauthParameters.getOAuthSignatureMethod());
        params.setBaseString(resourceURL);
        params.setHttpMethod("GET");
        params.setOauthSignature(signature);
        oauth.validateAuthenticationRequest(params);
        System.out.println("Access token " + this.params.getOauthToken() + " and access token secret " + this.params.getOauthTokenSecret() + " are valid.\n");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return "";
    }

    private String getRandomNumber() throws Exception {
        try {
            String secretKey = UUID.randomUUID().toString();
            String baseString = UUID.randomUUID().toString();
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(key);
            byte[] rawHmac = mac.doFinal(baseString.getBytes());
            String random = Base64.encode((byte[])rawHmac);
            random = random.replace("/", "_");
            random = random.replace("=", "a");
            random = random.replace("+", "f");
            return random;
        }
        catch (Exception e) {
            throw new Exception("Error when generating a random number.", e);
        }
    }

    private Parameters populateOauthConsumerData(String authHeader) {
        Parameters params = new Parameters();
        String splitChar = "&";
        if (authHeader != null) {
            String[] headers;
            if (authHeader.startsWith("OAuth ") || authHeader.startsWith("oauth ")) {
                authHeader = authHeader.substring(authHeader.indexOf("o"));
            }
            if ((headers = authHeader.split(splitChar)) != null && headers.length > 0) {
                for (int i = 0; i < headers.length; ++i) {
                    String[] elements = headers[i].split("=");
                    if (elements == null || elements.length <= 0) continue;
                    if ("oauth_consumer_key".equals(elements[0].trim())) {
                        params.setOauthConsumerKey(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_nonce".equals(elements[0].trim())) {
                        params.setOauthNonce(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_signature".equals(elements[0].trim())) {
                        params.setOauthSignature(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_signature_method".equals(elements[0].trim())) {
                        params.setOauthSignatureMethod(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_timestamp".equals(elements[0].trim())) {
                        params.setOauthTimeStamp(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_callback".equals(elements[0].trim())) {
                        params.setOauthCallback(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("scope".equals(elements[0].trim())) {
                        params.setScope(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("xoauth_displayname".equals(elements[0].trim())) {
                        params.setDisplayName(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_token".equals(elements[0].trim())) {
                        params.setOauthToken(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_verifier".equals(elements[0].trim())) {
                        params.setOauthTokenVerifier(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_token_secret".equals(elements[0].trim())) {
                        params.setOauthTokenSecret(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if ("oauth_version".equals(elements[0].trim())) {
                        params.setVersion(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                        continue;
                    }
                    if (!"oauth_callback_confirmed".equals(elements[0].trim())) continue;
                    params.setCallbackConfirmed(this.removeLeadingAndTrailingQuatation(elements[1].trim()));
                }
            }
        }
        return params;
    }

    private String removeLeadingAndTrailingQuatation(String base) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return URLDecoder.decode(result.trim());
    }
}

