/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.identity;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class KeystoreLoader
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(KeystoreLoader.class.getName());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        InputStream keystoreInputStream = this.getClass().getClassLoader().getResourceAsStream("keystore.properties");
        if (keystoreInputStream == null) {
            LOGGER.log(Level.SEVERE, "keystore.properties not found. Trust store properties will not be set.");
            return;
        }
        Properties keystoreProperties = new Properties();
        try {
            keystoreProperties.load(keystoreInputStream);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while loading properties.", e);
            return;
        }
        URL resource = this.getClass().getClassLoader().getResource(keystoreProperties.getProperty("keystorename"));
        if (resource != null) {
            try {
                String trustStorePath = Paths.get(resource.toURI()).toFile().getAbsolutePath();
                LOGGER.log(Level.INFO, "Setting trust store path to : " + trustStorePath);
                System.setProperty("javax.net.ssl.trustStore", trustStorePath);
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.SEVERE, "Unable to find keystore defined by properties. Trust store properties will not be set.", e);
            }
            System.setProperty("javax.net.ssl.trustStorePassword", keystoreProperties.getProperty("keystorepassword"));
        } else {
            LOGGER.log(Level.INFO, "Unable to find keystore defined by properties. Trust store properties will not be set.");
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

