/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.handler.step;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.builder.FileBasedConfigurationBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.handler.step.impl.DefaultStepHandler;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.handler.step.utils.CustomStepHandlerUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class CustomStepHandler
extends DefaultStepHandler {
    private static final Log log = LogFactory.getLog(CustomStepHandler.class);

    public void handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        try {
            int currentStep = context.getCurrentStep();
            StepConfig stepConfig = (StepConfig)context.getSequenceConfig().getStepMap().get(currentStep);
            String spName = context.getServiceProviderName();
            if (stepConfig != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating AuthConfigList of StepConfig in the step: " + currentStep + " of service " + "provider: " + spName));
                }
                this.updateStepConfig(request, context, stepConfig);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("stepConfig is null in step: " + currentStep + " of service provider: " + spName));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred during executing custom step handler.", (Throwable)e);
        }
        super.handle(request, response, context);
    }

    private void updateStepConfig(HttpServletRequest request, AuthenticationContext context, StepConfig stepConfig) {
        boolean isInternalIP;
        List authConfigList = stepConfig.getAuthenticatorList();
        ArrayList<AuthenticatorConfig> filteredAuthConfigList = new ArrayList<AuthenticatorConfig>();
        AuthenticatorConfig locatedIWAAuthenticatorConfig = null;
        AuthenticatorConfig locatedBasicAuthenticatorConfig = null;
        if (authConfigList != null) {
            for (AuthenticatorConfig config : authConfigList) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authenticator name : " + config.getName()));
                }
                if ("IWAKerberosAuthenticator".equals(config.getName())) {
                    locatedIWAAuthenticatorConfig = config;
                    continue;
                }
                if (!"BasicAuthenticator".equals(config.getName())) continue;
                locatedBasicAuthenticatorConfig = config;
            }
        } else if (log.isDebugEnabled()) {
            String spName = context.getServiceProviderName();
            int currentStep = context.getCurrentStep();
            log.debug((Object)("'AuthConfigList' is empty in the step : " + currentStep + " of service provider : " + spName));
        }
        String clientIpAddress = IdentityUtil.getClientIpAddress((HttpServletRequest)request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("client IP Address : " + clientIpAddress));
        }
        if (isInternalIP = CustomStepHandlerUtil.isInternalIP(clientIpAddress)) {
            if (locatedIWAAuthenticatorConfig != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Client IP address is from internal range. Hence modifying the authConfigList to include IWA Kerberos Authenticator for internal network users.");
                }
                filteredAuthConfigList.add(locatedIWAAuthenticatorConfig);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Client IP address is from internal range but IWA is not configured in Auth Config list.");
            }
        } else if (locatedBasicAuthenticatorConfig != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Client IP address is from external range. Hence modifying the authConfigList to include Basic Authenticator for external network users.");
            }
            filteredAuthConfigList.add(locatedBasicAuthenticatorConfig);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Client IP address is from external range but Basic-auth not available in Auth Config list.");
        }
        if (CustomStepHandlerUtil.isFireFox(request) && locatedIWAAuthenticatorConfig != null) {
            if (locatedBasicAuthenticatorConfig != null) {
                log.info((Object)"Defaulting to Basic Authentication for FireFox Browsers..");
                ArrayList<AuthenticatorConfig> authConfigListWithBasic = new ArrayList<AuthenticatorConfig>();
                authConfigListWithBasic.add(locatedBasicAuthenticatorConfig);
                this.updateAuthConfigList(context, stepConfig, authConfigListWithBasic, false);
            } else {
                log.info((Object)"Defaulting to Basic Authentication for FireFox Browsers..");
                ArrayList<AuthenticatorConfig> authConfigListWithBasic = new ArrayList<AuthenticatorConfig>();
                authConfigListWithBasic.add(this.getBasicAuthenticatorConfig(context));
                this.updateAuthConfigList(context, stepConfig, authConfigListWithBasic, false);
            }
        } else if (!this.hasIWAAuthenticationFailed(context) && locatedIWAAuthenticatorConfig != null && locatedBasicAuthenticatorConfig != null) {
            if (isInternalIP) {
                log.info((Object)"Defaulting to IWA for internal network users..");
            } else {
                log.info((Object)"Defaulting to basic authentication for external users..");
            }
            this.updateAuthConfigList(context, stepConfig, filteredAuthConfigList, filteredAuthConfigList.size() > 1);
        } else if (this.hasIWAAuthenticationFailed(context) && locatedIWAAuthenticatorConfig != null && locatedBasicAuthenticatorConfig != null) {
            log.info((Object)"IWA Authentication Failed in previous attempt. Fallback to Basic Authentication..");
            ArrayList<AuthenticatorConfig> authConfigListWithBasic = new ArrayList<AuthenticatorConfig>();
            authConfigListWithBasic.add(locatedBasicAuthenticatorConfig);
            this.updateAuthConfigList(context, stepConfig, authConfigListWithBasic, false);
        }
    }

    private void updateAuthConfigList(AuthenticationContext context, StepConfig stepConfig, List<AuthenticatorConfig> authConfigList, boolean isMultiOption) {
        stepConfig.setAuthenticatorList(authConfigList);
        stepConfig.setMultiOption(isMultiOption);
        context.getSequenceConfig().getStepMap().put(context.getCurrentStep(), stepConfig);
    }

    protected void doAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, AuthenticatorConfig authenticatorConfig) throws FrameworkException {
        super.doAuthentication(request, response, context, authenticatorConfig);
        try {
            ApplicationAuthenticator authenticator = authenticatorConfig.getApplicationAuthenticator();
            if ("IWAKerberosAuthenticator".equals(authenticator.getName()) && !context.isRequestAuthenticated()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"IWA authenticator failed in this attempt. Adding context property 'IWAAuthenticatorStatus' to detect IWA authentication failure during handle method.");
                }
                context.getProperties().put("IWAAuthenticatorStatus", "failed");
                SequenceConfig sequenceConfig = context.getSequenceConfig();
                int currentStep = context.getCurrentStep();
                String spName = context.getServiceProviderName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating AuthConfigList of StepConfig in the step: " + currentStep + " of service " + "provider: " + spName + " with basic authenticator config."));
                }
                StepConfig stepConfig = (StepConfig)sequenceConfig.getStepMap().get(currentStep);
                AuthenticatorConfig basicAuthConfig = this.getBasicAuthenticatorConfig(context);
                ArrayList<AuthenticatorConfig> filteredAuthConfigList = new ArrayList<AuthenticatorConfig>();
                filteredAuthConfigList.add(basicAuthConfig);
                filteredAuthConfigList.add(authenticatorConfig);
                this.updateAuthConfigList(context, stepConfig, filteredAuthConfigList, filteredAuthConfigList.size() > 1);
                stepConfig.setRetrying(true);
                context.getSequenceConfig().getStepMap().put(context.getCurrentStep(), stepConfig);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred during CustomStepHandler doAuthentication method.", (Throwable)e);
            context.setRequestAuthenticated(false);
        }
    }

    private boolean hasIWAAuthenticationFailed(AuthenticationContext context) {
        String iwaStatus = (String)context.getProperty("IWAAuthenticatorStatus");
        return "failed".equals(iwaStatus);
    }

    private AuthenticatorConfig getBasicAuthenticatorConfig(AuthenticationContext context) {
        try {
            AuthenticatorConfig basicAuthConfig = FileBasedConfigurationBuilder.getInstance().getAuthenticatorBean("BasicAuthenticator");
            IdentityProvider localIDP = IdentityProviderManager.getInstance().getIdPByName("LOCAL", context.getTenantDomain());
            basicAuthConfig.getIdps().put("LOCAL", localIDP);
            basicAuthConfig.setEnabled(true);
            return basicAuthConfig;
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)"Error occurred while retrieving local IDP.", (Throwable)e);
            return null;
        }
    }
}

