/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.handler.step.utils;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.SubnetUtils;
import org.wso2.carbon.identity.handler.step.utils.IPRangeDataHolder;

public class CustomStepHandlerUtil {
    private static final Log log = LogFactory.getLog(CustomStepHandlerUtil.class);

    private CustomStepHandlerUtil() {
    }

    public static boolean isFireFox(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        return StringUtils.containsIgnoreCase((String)userAgent, (String)"Firefox");
    }

    public static boolean isInternalIP(String ipAddress) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking if IP address is internal. IP address : " + ipAddress));
        }
        boolean isInternalIP = false;
        List<String> internalIpList = IPRangeDataHolder.getInstance().getIPRangeList();
        if (internalIpList != null) {
            isInternalIP = internalIpList.stream().anyMatch(s -> {
                SubnetUtils.SubnetInfo subnetInfo = IPRangeDataHolder.getInstance().getSubnetUtils((String)s).getInfo();
                boolean isIpInRange = subnetInfo.isInRange(ipAddress);
                if (isIpInRange && log.isDebugEnabled()) {
                    log.debug((Object)("client IP : " + ipAddress + " belongs to the internal network range : " + s));
                }
                return isIpInRange;
            });
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"internal IP list in config file is empty.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Is Client IP from internal network : " + isInternalIP));
        }
        return isInternalIP;
    }
}

