/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.handler.step.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.SubnetUtils;

public class IPRangeDataHolder {
    private static volatile IPRangeDataHolder dataHolder;
    private List<String> ipRangeList = new ArrayList<String>();
    private Map<String, SubnetUtils> subnetUtilsMap = new HashMap<String, SubnetUtils>();
    private static final Log log;

    private IPRangeDataHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IPRangeDataHolder getInstance() {
        if (dataHolder != null) return dataHolder;
        Class<IPRangeDataHolder> clazz = IPRangeDataHolder.class;
        synchronized (IPRangeDataHolder.class) {
            if (dataHolder != null) return dataHolder;
            dataHolder = new IPRangeDataHolder();
            dataHolder.readIPListFromConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataHolder;
        }
    }

    public List<String> getIPRangeList() {
        return this.ipRangeList;
    }

    public SubnetUtils getSubnetUtils(String range) {
        return this.subnetUtilsMap.computeIfAbsent(range, SubnetUtils::new);
    }

    public Map<String, SubnetUtils> getSubnetUtilsMap() {
        return this.subnetUtilsMap;
    }

    private void readIPListFromConfig() {
        if (Files.exists(Paths.get("repository/conf/identity/internal_ip_addresses.txt", new String[0]), new LinkOption[0])) {
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new FileReader("repository/conf/identity/internal_ip_addresses.txt"));){
                String str;
                while ((str = in.readLine()) != null) {
                    stringBuilder.append(str);
                }
                String[] ipRanges = StringUtils.split((String)stringBuilder.toString().trim().replaceAll("\\s", ""), (String)",");
                if (ipRanges != null) {
                    this.ipRangeList.addAll(Arrays.asList(ipRanges));
                }
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while reading the file in the path : repository/conf/identity/internal_ip_addresses.txt", (Throwable)e);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not find config file in the path : repository/conf/identity/internal_ip_addresses.txt. Hence adding the default values : '10.0.0.0/8', '172.16.0.0/12', '192.168.0.0/16'");
            }
            this.ipRangeList = Arrays.asList("10.0.0.0/8", "172.16.0.0/12", "192.168.0.0/16");
        }
        if (this.ipRangeList != null) {
            for (String ipRange : this.ipRangeList) {
                SubnetUtils subnet = new SubnetUtils(ipRange);
                this.subnetUtilsMap.put(ipRange, subnet);
            }
        }
    }

    static {
        log = LogFactory.getLog(IPRangeDataHolder.class);
    }
}

