/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.samples.sts;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.client.STSClient;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.secpolicy.SP11Constants;
import org.wso2.carbon.identity.samples.sts.ClientConstants;

public class Client {
    private boolean enableRelyingParty;
    private static boolean enableValidateBinding;
    private static boolean enableRenewing;
    private static boolean isSetRenewing;
    private static boolean isSetValidate;
    private static String tokenType;
    private String subjectConfirmationMethod;
    private String keystorePath;
    private String repoPath;
    private String stsEPR;
    private String relyingPartyEPR;
    private String stsPolicyPath;
    private String relyingPartyPolicyPath;
    private String echoRequestMsg;
    private String username;
    private String claimDialect;
    private String[] claimUris;
    private String encryptionUser;
    private String userCertAlias;
    private String pwdCallbackClass;
    private String keystorePwd;

    public static void main(String[] args) {
        if (args.length != 0) {
            if (args[0].equals("samlVersion")) {
                tokenType = args[1];
            }
            if (args[2].equals("renew")) {
                enableRenewing = Boolean.parseBoolean(args[3]);
                isSetRenewing = true;
            }
            if (args[4].equals("validate")) {
                enableValidateBinding = Boolean.parseBoolean(args[5]);
                isSetValidate = true;
            }
        }
        Client client = new Client();
        client.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        try {
            this.loadConfigurations();
            System.setProperty("javax.net.ssl.trustStore", this.keystorePath);
            System.setProperty("javax.net.ssl.trustStorePassword", this.keystorePwd);
            ConfigurationContext configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.repoPath);
            STSClient stsClient = new STSClient(configCtx);
            stsClient.setRstTemplate(this.getRSTTemplate());
            String action = null;
            String responseTokenID = null;
            action = TrustUtil.getActionValue((int)1, (String)"/RST/Issue");
            stsClient.setAction(action);
            Policy stsPolicy = this.loadPolicy(this.stsPolicyPath);
            RampartConfig rampartConfig = this.buildRampartConfig();
            stsPolicy.addAssertion((Assertion)rampartConfig);
            Token responseToken = stsClient.requestSecurityToken(null, this.stsEPR, stsPolicy, this.relyingPartyEPR);
            TokenStorage store = TrustUtil.getTokenStore((ConfigurationContext)configCtx);
            responseTokenID = responseToken.getId();
            store.add(responseToken);
            System.out.println(responseToken.getToken().toString());
            String renewedTokenID = null;
            if (enableRenewing) {
                System.out.println("Renewing " + tokenType);
                String TokenProfile = null;
                if (tokenType.equals("1.1")) {
                    TokenProfile = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
                } else if (tokenType.equals("2.0")) {
                    TokenProfile = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
                }
                stsClient.setRstTemplate(this.getRSTTemplate());
                boolean tokenRenewed = stsClient.renewToken(responseTokenID, TokenProfile, this.stsEPR, stsPolicy, store);
                System.out.println("tokenRenewed : " + tokenRenewed);
                Token renewedToken = store.getRenewedTokens()[0];
                renewedTokenID = renewedToken.getId();
                System.out.println("Renewed Token : \n" + renewedToken.getToken().toString());
            }
            if (enableValidateBinding) {
                stsClient = new STSClient(configCtx);
                action = TrustUtil.getActionValue((int)1, (String)"/RST/Validate");
                stsClient.setAction(action);
                String tokenID = null;
                tokenID = renewedTokenID != null ? renewedTokenID : responseTokenID;
                boolean isValid = stsClient.validateToken(tokenID, this.stsEPR, stsPolicy);
                if (isValid) {
                    if (enableRenewing) {
                        System.out.println("Renewed SAML " + tokenType + " Token is valid");
                    } else {
                        System.out.println("Response SAML " + tokenType + " Token is valid");
                    }
                } else if (enableRenewing) {
                    System.out.println("Renewed SAML " + tokenType + " Token is invalid");
                } else {
                    System.out.println("Response SAML " + tokenType + " Token is invalid");
                }
            }
            if (this.enableRelyingParty) {
                OMElement responseElem = null;
                ServiceClient serClient = new ServiceClient(configCtx, null);
                serClient.engageModule("addressing");
                serClient.engageModule("rampart");
                Policy sec_policy = this.loadPolicy(this.relyingPartyPolicyPath);
                sec_policy.addAssertion((Assertion)rampartConfig);
                serClient.getOptions().setProperty("rampartPolicy", (Object)sec_policy);
                serClient.getOptions().setProperty("customIssuedToken", (Object)renewedTokenID);
                serClient.getOptions().setAction("urn:echoString");
                serClient.getOptions().setTo(new EndpointReference(this.relyingPartyEPR));
                responseElem = serClient.sendReceive(this.getPayload(this.echoRequestMsg));
                serClient.getOptions().setCallTransportCleanup(true);
                System.out.println(responseElem.toString());
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private void loadConfigurations() throws IOException {
        Properties properties = new Properties();
        FileInputStream freader = new FileInputStream(ClientConstants.PROPERTIES_FILE_PATH);
        properties.load(freader);
        this.enableRelyingParty = Boolean.parseBoolean(properties.getProperty("enable.relyingParty"));
        if (!isSetValidate) {
            enableValidateBinding = Boolean.parseBoolean(properties.getProperty("enable.binding.validate"));
        }
        if (!isSetRenewing) {
            enableRenewing = Boolean.parseBoolean(properties.getProperty("enable.renew"));
        }
        if (tokenType == null) {
            tokenType = properties.getProperty("saml.token.type");
        }
        this.subjectConfirmationMethod = properties.getProperty("subject.confirmation.method");
        this.keystorePath = ClientConstants.RESOURCE_PATH + properties.getProperty("path.keystore");
        this.repoPath = ClientConstants.RESOURCE_PATH + properties.getProperty("path.repo");
        this.stsEPR = properties.getProperty("address.sts");
        this.relyingPartyEPR = properties.getProperty("address.relyingParty");
        this.stsPolicyPath = ClientConstants.RESOURCE_PATH + properties.getProperty("path.policy.sts");
        this.relyingPartyPolicyPath = ClientConstants.RESOURCE_PATH + properties.getProperty("path.policy.relyingParty");
        this.echoRequestMsg = properties.getProperty("relyingParty.message");
        this.username = properties.getProperty("ut.username");
        this.claimDialect = properties.getProperty("claim.dialect");
        this.claimUris = properties.getProperty("claim.uris").split(",");
        this.encryptionUser = properties.getProperty("encryption.user");
        this.userCertAlias = properties.getProperty("user.cert.alias");
        this.pwdCallbackClass = properties.getProperty("password.callback.class");
        this.keystorePwd = properties.getProperty("keystore.password");
    }

    private OMElement getRSTTemplate() throws TrustException {
        OMFactory omFac = OMAbstractFactory.getOMFactory();
        OMElement element = omFac.createOMElement(SP11Constants.REQUEST_SECURITY_TOKEN_TEMPLATE);
        if ("2.0".equals(tokenType)) {
            TrustUtil.createTokenTypeElement((int)1, (OMElement)element).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        } else if ("1.1".equals(tokenType)) {
            TrustUtil.createTokenTypeElement((int)1, (OMElement)element).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        }
        if ("b".equals(this.subjectConfirmationMethod)) {
            TrustUtil.createKeyTypeElement((int)1, (OMElement)element, (String)"/Bearer");
        } else if ("h".equals(this.subjectConfirmationMethod)) {
            TrustUtil.createKeyTypeElement((int)1, (OMElement)element, (String)"/SymmetricKey");
        }
        OMElement claimElement = TrustUtil.createClaims((int)1, (OMElement)element, (String)this.claimDialect);
        this.addClaimType(claimElement, this.claimUris);
        return element;
    }

    private void addClaimType(OMElement parent, String[] claimUris) {
        OMElement element = null;
        for (String attr : claimUris) {
            element = parent.getOMFactory().createOMElement(new QName("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimType", "wsid"), (OMContainer)parent);
            element.addAttribute(parent.getOMFactory().createOMAttribute("Uri", null, attr));
        }
    }

    private Policy loadPolicy(String policyPath) throws XMLStreamException, FileNotFoundException {
        StAXOMBuilder omBuilder = new StAXOMBuilder(policyPath);
        return PolicyEngine.getPolicy((OMElement)omBuilder.getDocumentElement());
    }

    private RampartConfig buildRampartConfig() {
        RampartConfig rampartConfig = new RampartConfig();
        rampartConfig.setUser(this.username);
        rampartConfig.setEncryptionUser(this.encryptionUser);
        rampartConfig.setUserCertAlias(this.userCertAlias);
        rampartConfig.setPwCbClass(this.pwdCallbackClass);
        Properties cryptoProperties = new Properties();
        cryptoProperties.put("org.apache.ws.security.crypto.merlin.keystore.type", "PKCS12");
        cryptoProperties.put("org.apache.ws.security.crypto.merlin.file", this.keystorePath);
        cryptoProperties.put("org.apache.ws.security.crypto.merlin.keystore.password", this.keystorePwd);
        CryptoConfig cryptoConfig = new CryptoConfig();
        cryptoConfig.setProvider("org.apache.ws.security.components.crypto.Merlin");
        cryptoConfig.setProp(cryptoProperties);
        rampartConfig.setEncrCryptoConfig(cryptoConfig);
        rampartConfig.setSigCryptoConfig(cryptoConfig);
        return rampartConfig;
    }

    private OMElement getPayload(String value) {
        OMFactory factory = null;
        OMNamespace ns = null;
        OMElement elem = null;
        OMElement childElem = null;
        factory = OMAbstractFactory.getOMFactory();
        ns = factory.createOMNamespace("http://echo.services.core.carbon.wso2.org", "ns");
        elem = factory.createOMElement("echoString", ns);
        childElem = factory.createOMElement("in", null);
        childElem.setText(value);
        elem.addChild((OMNode)childElem);
        return elem;
    }
}

