/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.samples.sts;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.wso2.carbon.identity.samples.sts.ClientConstants;

public class PasswordCBHandler
implements CallbackHandler {
    private String username;
    private String password;
    private String keyAlias;
    private String keyPassword;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.readUsernamePasswordFromProperties();
        WSPasswordCallback pwcb = (WSPasswordCallback)callbacks[0];
        String id = pwcb.getIdentifier();
        int usage = pwcb.getUsage();
        if (usage == 2) {
            if (this.username.equals(id)) {
                pwcb.setPassword(this.password);
            }
        } else if ((usage == 3 || usage == 1) && this.keyAlias.equals(id)) {
            pwcb.setPassword(this.keyPassword);
        }
    }

    public void readUsernamePasswordFromProperties() throws IOException {
        Properties properties = new Properties();
        FileInputStream freader = new FileInputStream(ClientConstants.PROPERTIES_FILE_PATH);
        properties.load(freader);
        this.username = properties.getProperty("ut.username");
        this.password = properties.getProperty("ut.password");
        this.keyAlias = properties.getProperty("user.cert.alias");
        this.keyPassword = properties.getProperty("user.cert.password");
    }
}

