/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.custom.user.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasypt.util.password.StrongPasswordEncryptor;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.common.AuthenticationResult;
import org.wso2.carbon.user.core.common.FailureReason;
import org.wso2.carbon.user.core.common.User;
import org.wso2.carbon.user.core.jdbc.UniqueIDJDBCUserStoreManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.utils.Secret;

public class CustomUserStoreManager
extends UniqueIDJDBCUserStoreManager {
    private static final Log log = LogFactory.getLog(CustomUserStoreManager.class);
    private static final StrongPasswordEncryptor passwordEncryptor = new StrongPasswordEncryptor();

    public CustomUserStoreManager() {
    }

    public CustomUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId);
        log.info((Object)"CustomUserStoreManager initialized...");
    }

    public AuthenticationResult doAuthenticateWithUserName(String userName, Object credential) throws UserStoreException {
        AuthenticationResult authenticationResult;
        boolean isAuthenticated = false;
        String userID = null;
        if (!this.isValidUserName(userName)) {
            String reason = "Username validation failed.";
            if (log.isDebugEnabled()) {
                log.debug((Object)reason);
            }
            return this.getAuthenticationResult(reason);
        }
        if (!this.isValidCredentials(credential)) {
            String reason = "Password validation failed.";
            if (log.isDebugEnabled()) {
                log.debug((Object)reason);
            }
            return this.getAuthenticationResult(reason);
        }
        try {
            String candidatePassword = String.copyValueOf(((Secret)credential).getChars());
            Connection dbConnection = null;
            ResultSet rs = null;
            PreparedStatement prepStmt = null;
            String sql = null;
            dbConnection = this.getDBConnection();
            dbConnection.setAutoCommit(false);
            sql = this.realmConfig.getUserStoreProperty("SelectUserNameSQL");
            if (log.isDebugEnabled()) {
                log.debug((Object)sql);
            }
            prepStmt = dbConnection.prepareStatement(sql);
            prepStmt.setString(1, userName);
            if (sql.contains("UM_TENANT_ID")) {
                prepStmt.setInt(2, this.tenantId);
            }
            if ((rs = prepStmt.executeQuery()).next()) {
                userID = rs.getString(1);
                String storedPassword = rs.getString(3);
                boolean requireChange = rs.getBoolean(5);
                Timestamp changedTime = rs.getTimestamp(6);
                GregorianCalendar gc = new GregorianCalendar();
                gc.add(10, -24);
                Date date = gc.getTime();
                if (!requireChange || !changedTime.before(date)) {
                    isAuthenticated = passwordEncryptor.checkPassword(candidatePassword, storedPassword);
                }
            }
            dbConnection.commit();
            log.info((Object)(userName + " is authenticated? " + isAuthenticated));
        }
        catch (SQLException exp) {
            try {
                this.getDBConnection().rollback();
            }
            catch (SQLException e1) {
                throw new UserStoreException("Transaction rollback connection error occurred while retrieving user authentication info. Authentication Failure.", (Throwable)e1);
            }
            log.error((Object)"Error occurred while retrieving user authentication info.", (Throwable)exp);
            throw new UserStoreException("Authentication Failure");
        }
        if (isAuthenticated) {
            User user = this.getUser(userID, userName);
            authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.SUCCESS);
            authenticationResult.setAuthenticatedUser(user);
            return authenticationResult;
        }
        authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        authenticationResult.setFailureReason(new FailureReason("Invalid credentials."));
        return authenticationResult;
    }

    protected String preparePassword(Object password, String saltValue) throws UserStoreException {
        if (password != null) {
            String candidatePassword = String.copyValueOf(((Secret)password).getChars());
            log.info((Object)"Generating hash value using jasypt...");
            return passwordEncryptor.encryptPassword(candidatePassword);
        }
        log.error((Object)"Password cannot be null");
        throw new UserStoreException("Authentication Failure");
    }

    private AuthenticationResult getAuthenticationResult(String reason) {
        AuthenticationResult authenticationResult = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.FAIL);
        authenticationResult.setFailureReason(new FailureReason(reason));
        return authenticationResult;
    }
}

