/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AppId {
    private static Logger LOGGER = Logger.getLogger(AppId.class.getSimpleName());
    private static final String RESPONSE_FORMATTED_FILE = "response_unformatted.xml";
    private static final String RESPONSE_TAG = "ax2140:applicationID";

    public static void main(String[] args) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(RESPONSE_FORMATTED_FILE));
            NodeList appId = doc.getElementsByTagName(RESPONSE_TAG);
            if (appId.item(0) != null) {
                Element appElement = (Element)appId.item(0);
                NodeList appList = appElement.getChildNodes();
                System.out.println(appList.item(0).getNodeValue().trim());
            } else {
                LOGGER.info("Application ID not found.");
            }
        }
        catch (SAXParseException err) {
            LOGGER.info("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.exit(-1);
        }
        catch (SAXException e) {
            LOGGER.info("** SAX error " + e.getMessage());
            System.exit(-1);
        }
        catch (ParserConfigurationException er) {
            LOGGER.info("** Parser configuration error " + er.getMessage());
            System.exit(-1);
        }
        catch (IOException error) {
            LOGGER.info("** Error occurred " + error.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }
}

