/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sp.mgt.workflow.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.workflow.mgt.bean.Entity;
import org.wso2.carbon.identity.workflow.mgt.exception.WorkflowException;
import org.wso2.carbon.identity.workflow.mgt.extension.AbstractWorkflowRequestHandler;
import org.wso2.carbon.identity.workflow.mgt.util.WorkflowRequestStatus;

public class SPCreateHandler
extends AbstractWorkflowRequestHandler {
    private static final Map<String, String> PARAM_DEFINITION;
    private static Log log;

    public void onWorkflowCompletion(String status, Map<String, Object> requestParams, Map<String, Object> responseAdditionalParams, int tenantId) throws WorkflowException {
        String applicationName = (String)requestParams.get("Application Name");
        String applicationDescription = (String)requestParams.get("Application Description");
        String tenantDoamin = (String)requestParams.get("Tenant Domain");
        String username = (String)requestParams.get("Username");
        if (WorkflowRequestStatus.APPROVED.toString().equals(status) || WorkflowRequestStatus.SKIPPED.toString().equals(status)) {
            try {
                ApplicationManagementService applicationMgtService = ApplicationManagementService.getInstance();
                ServiceProvider serviceProvider = new ServiceProvider();
                serviceProvider.setApplicationName(applicationName);
                serviceProvider.setDescription(applicationDescription);
                applicationMgtService.createApplication(serviceProvider, tenantDoamin, username);
            }
            catch (Exception e) {
                throw new WorkflowException(e.getMessage(), (Throwable)e);
            }
        } else {
            if (this.retryNeedAtCallback()) {
                SPCreateHandler.unsetWorkFlowCompleted();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding user is aborted for SP '" + applicationName + "', Reason: Workflow response was " + status));
            }
        }
    }

    public boolean retryNeedAtCallback() {
        return true;
    }

    public String getEventId() {
        return "ADD_SP";
    }

    public Map<String, String> getParamDefinitions() {
        return PARAM_DEFINITION;
    }

    public String getFriendlyName() {
        return "Add SP";
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "SP Operations";
    }

    public boolean startSPCreateWorkflow(ServiceProvider serviceProvider, String tenantDomain, String userName) throws WorkflowException {
        HashMap<String, Object> wfParams = new HashMap<String, Object>();
        HashMap nonWfParams = new HashMap();
        wfParams.put("Application ID", serviceProvider.getApplicationID());
        wfParams.put("Application Name", serviceProvider.getApplicationName());
        wfParams.put("Application Description", serviceProvider.getDescription());
        wfParams.put("Tenant Domain", tenantDomain);
        wfParams.put("Username", userName);
        String uuid = UUID.randomUUID().toString();
        Entity[] entities = new Entity[]{new Entity(serviceProvider.getApplicationName(), "SP", -1234)};
        if (!Boolean.TRUE.equals(SPCreateHandler.getWorkFlowCompleted()) && !this.isValidOperation(entities)) {
            throw new WorkflowException("Operation is not valid.");
        }
        boolean state = this.startWorkFlow(wfParams, nonWfParams, uuid).getExecutorResultState().state();
        return state;
    }

    public boolean isValidOperation(Entity[] entities) throws WorkflowException {
        return true;
    }

    static {
        log = LogFactory.getLog(SPCreateHandler.class);
        PARAM_DEFINITION = new LinkedHashMap<String, String>();
        PARAM_DEFINITION.put("Application ID", "INTEGER");
        PARAM_DEFINITION.put("Application Name", "STRING");
        PARAM_DEFINITION.put("Application Description", "STRING");
        PARAM_DEFINITION.put("Tenant Domain", "STRING");
        PARAM_DEFINITION.put("Username", "STRING");
    }
}

