/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.scope.validator;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.identity.oauth2.validators.scope.ScopeValidator;

@Component(name="CustomScopeValidator", immediate=true, service={ScopeValidator.class})
public class CustomScopeValidator
implements ScopeValidator {
    Log log = LogFactory.getLog(CustomScopeValidator.class);

    public boolean validateScope(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext) {
        this.log.info((Object)"Validating the scopes of the Authorization Request with Custom Scope Validator.");
        String[] approvedScope = oAuthAuthzReqMessageContext.getApprovedScope();
        ArrayList<String> validScopes = new ArrayList<String>();
        for (String scope : approvedScope) {
            if (scope.startsWith("test")) continue;
            validScopes.add(scope);
        }
        oAuthAuthzReqMessageContext.setApprovedScope(validScopes.toArray(new String[0]));
        this.log.info((Object)"Custom Scope Validator validated the scopes of the Authorization Request.");
        return true;
    }

    public boolean validateScope(OAuthTokenReqMessageContext oAuthTokenReqMessageContext) {
        this.log.info((Object)"Validating the scopes of the Access Token Request with Custom Scope Validator.");
        String[] approvedScope = oAuthTokenReqMessageContext.getScope();
        ArrayList<String> validScopes = new ArrayList<String>();
        for (String scope : approvedScope) {
            if (scope.startsWith("test")) continue;
            validScopes.add(scope);
        }
        oAuthTokenReqMessageContext.setScope(validScopes.toArray(new String[0]));
        this.log.info((Object)"Custom Scope Validator validated the scopes of the Access Token Request.");
        return true;
    }

    public boolean validateScope(OAuth2TokenValidationMessageContext oAuth2TokenValidationMessageContext) {
        return true;
    }

    public String getName() {
        return "CustomScopeValidator";
    }
}

