/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.sample.user;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.wso2.charon.core.attributes.AbstractAttribute;
import org.wso2.charon.core.attributes.Attribute;
import org.wso2.charon.core.attributes.DefaultAttributeFactory;
import org.wso2.charon.core.attributes.MultiValuedAttribute;
import org.wso2.charon.core.client.SCIMClient;
import org.wso2.charon.core.exceptions.CharonException;
import org.wso2.charon.core.objects.AbstractSCIMObject;
import org.wso2.charon.core.objects.User;
import org.wso2.charon.core.schema.AttributeSchema;
import org.wso2.charon.core.schema.SCIMSchemaDefinitions;
import org.wso2.scim.sample.utils.SCIMSamplesUtils;

public class CreateUser {
    private static String externalID = "hasini@wso2.com";
    private static String[] emails = new String[]{"hasini@gmail.com"};
    private static String displayName = "Hasini";
    private static String password = "dummyPW1";
    private static String language = "Sinhala";
    private static String phone_number = "0772508354";

    public static void main(String[] args) {
        try {
            SCIMSamplesUtils.loadConfiguration();
            SCIMSamplesUtils.setKeyStore();
            SCIMClient scimClient = new SCIMClient();
            User scimUser = scimClient.createUser();
            scimUser.setUserName(SCIMSamplesUtils.userNameToCreateUser);
            scimUser.setExternalId(externalID);
            scimUser.setEmails(emails);
            scimUser.setDisplayName(displayName);
            scimUser.setPassword(password);
            scimUser.setPhoneNumber(phone_number, "work", false);
            scimUser.setFamilyName("Gunasinghe");
            HashMap<String, String> subs = new HashMap<String, String>();
            subs.put("display", "ABC User");
            subs.put("value", "00eU0000000EAs4");
            MultiValuedAttribute entAttr = new MultiValuedAttribute("entitlements");
            entAttr.setComplexValue(subs);
            entAttr = (MultiValuedAttribute)DefaultAttributeFactory.createAttribute((AttributeSchema)SCIMSchemaDefinitions.ENTITLEMENTS, (AbstractAttribute)entAttr);
            scimUser.setAttribute((Attribute)entAttr);
            String encodedUser = scimClient.encodeSCIMObject((AbstractSCIMObject)scimUser, "json");
            System.out.println("");
            System.out.println("");
            System.out.println("/******User to be created in json format: " + encodedUser + "******/");
            System.out.println("");
            PostMethod postMethod = new PostMethod(SCIMSamplesUtils.userEndpointURL);
            String authHeader = SCIMSamplesUtils.getAuthorizationHeader();
            postMethod.addRequestHeader("Authorization", authHeader);
            StringRequestEntity requestEntity = new StringRequestEntity(encodedUser, "application/json", null);
            postMethod.setRequestEntity((RequestEntity)requestEntity);
            HttpClient httpClient = new HttpClient();
            int responseStatus = httpClient.executeMethod((HttpMethod)postMethod);
            String response = postMethod.getResponseBodyAsString();
            System.out.println("");
            System.out.println("");
            System.out.println("/******SCIM user creation response status: " + responseStatus);
            System.out.println("SCIM user creation response data: " + response + "******/");
            System.out.println("");
        }
        catch (CharonException e) {
            e.printStackTrace();
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

