/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.bulk.export;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.wso2.scim.bulk.export.HttpClient;
import org.wso2.scim.bulk.export.JSONFlattener;

public class BulkExportUsers {
    private static final String SCIM_USER_ENDPOINT = "scim2/Users";
    private static final String PATH_SEPARATOR = "/";
    private static final String NONE = "none";
    private static final String DEFAULT_CSV_FILE = "users.csv";
    private static final Logger LOGGER = Logger.getLogger(BulkExportUsers.class.getName());

    public static void main(String[] args) throws IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        if (args.length < 6) {
            LOGGER.log(Level.INFO, "Invalid arguments! Please provide valid arguments to host address, username and password.");
            return;
        }
        HashSet<String> attributesToExclude = new HashSet<String>(Arrays.asList("schemas", "meta_location", "meta_lastModified", "meta_resourceType"));
        String hostAddress = args[0];
        String username = args[1];
        String password = args[2];
        String csvDirectory = DEFAULT_CSV_FILE;
        if (!NONE.equals(args[3])) {
            csvDirectory = args[3];
        }
        String attributes = null;
        if (!NONE.equals(args[4])) {
            attributes = args[4];
        }
        if (!NONE.equals(args[5])) {
            attributesToExclude.addAll(Arrays.asList(args[5].split(",")));
        }
        URIBuilder builder = new URIBuilder(hostAddress + PATH_SEPARATOR + SCIM_USER_ENDPOINT);
        if (attributes != null) {
            builder.setParameter("attributes", attributes);
        }
        HttpGet request = HttpClient.createGetHttpRequest(builder, username, password);
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build();
        try (CloseableHttpClient client = HttpClientBuilder.create().setSSLContext(sslContext).build();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            if (200 == response.getStatusLine().getStatusCode()) {
                int i;
                String stringResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                JsonNode jsonTree = new ObjectMapper().readTree(stringResponse);
                JsonNode usersNode = jsonTree.at("/Resources");
                ArrayNode usersArrayNode = new ObjectMapper().createArrayNode();
                if (usersNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)usersNode;
                    for (i = 0; i < arrayNode.size(); ++i) {
                        JsonNode arrayElement = arrayNode.get(i);
                        usersArrayNode.add((JsonNode)JSONFlattener.generateFlatJSON(new ObjectMapper().createObjectNode(), arrayElement, null, attributesToExclude));
                    }
                }
                CsvSchema.Builder csvSchemaBuilder = CsvSchema.builder();
                for (i = 0; i < usersArrayNode.size(); ++i) {
                    usersArrayNode.get(i).fieldNames().forEachRemaining(fieldName -> {
                        if (!csvSchemaBuilder.hasColumn(fieldName)) {
                            csvSchemaBuilder.addColumn(fieldName);
                        }
                    });
                }
                CsvSchema csvSchema = csvSchemaBuilder.build().withHeader();
                CsvMapper csvMapper = new CsvMapper();
                csvMapper.writerFor(ArrayNode.class).with((FormatSchema)csvSchema).writeValue(new File(csvDirectory), (Object)usersArrayNode);
                LOGGER.log(Level.INFO, "User information was successfully written to : " + csvDirectory + " file.");
            } else {
                LOGGER.log(Level.INFO, request.getMethod() + " Request to " + request.getURI().toString() + " returned the status code : " + response.getStatusLine());
            }
        }
    }
}

