/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.bulk.export;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Set;

public class JSONFlattener {
    private static final String EMAILS_ATTRIBUTE = "emails";
    private static final String FIELD_SEPARATOR = "_";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String DEFAULT_TYPE = "work";

    public static ObjectNode generateFlatJSON(ObjectNode flatJsonNode, JsonNode node, String prefix, Set<String> excludedAttributes) {
        if (flatJsonNode == null) {
            flatJsonNode = new ObjectMapper().createObjectNode();
        }
        if (node.isObject()) {
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode subNode = node.get(fieldName);
                if (prefix != null) {
                    if (excludedAttributes.contains(prefix + FIELD_SEPARATOR + fieldName)) continue;
                    JSONFlattener.generateFlatJSON(flatJsonNode, subNode, prefix + FIELD_SEPARATOR + fieldName, excludedAttributes);
                    continue;
                }
                if (excludedAttributes.contains(fieldName)) continue;
                JSONFlattener.generateFlatJSON(flatJsonNode, subNode, fieldName, excludedAttributes);
            }
        } else if (node.isArray() && !excludedAttributes.contains(prefix)) {
            ArrayNode arrayNode = (ArrayNode)node;
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode arrayElement = arrayNode.get(i);
                if (arrayElement.get(TYPE_ATTRIBUTE) != null) {
                    JSONFlattener.generateFlatJSON(flatJsonNode, arrayElement.get(VALUE_ATTRIBUTE), prefix + FIELD_SEPARATOR + arrayElement.get(TYPE_ATTRIBUTE).textValue(), excludedAttributes);
                    continue;
                }
                if (prefix.contains(EMAILS_ATTRIBUTE)) {
                    JSONFlattener.generateFlatJSON(flatJsonNode, arrayElement, prefix + FIELD_SEPARATOR + DEFAULT_TYPE, excludedAttributes);
                    continue;
                }
                JSONFlattener.generateFlatJSON(flatJsonNode, arrayElement, prefix + String.valueOf(i), excludedAttributes);
            }
        } else if (!excludedAttributes.contains(prefix)) {
            flatJsonNode.put(prefix, node.textValue());
        }
        return flatJsonNode;
    }
}

