/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.bulk.export;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.wso2.scim.bulk.export.HttpClient;
import org.wso2.scim.bulk.export.JSONFlattener;

public class BulkExportUsers {
    private static final String SCIM_USER_ENDPOINT = "scim2/Users";
    private static final String PATH_SEPARATOR = "/";
    private static final String NONE = "none";
    private static final String DEFAULT_CSV_FILE = "users.csv";
    private static final int START_INDEX = 1;
    private static final int DEFAULT_COUNT = 100;
    private static final int MAX_COUNT = -1;
    private static final Logger LOGGER = Logger.getLogger(BulkExportUsers.class.getName());

    public static void main(String[] args) throws IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        if (args.length < 6) {
            LOGGER.log(Level.INFO, "Invalid arguments! Please provide valid arguments to host address, username and password.");
            return;
        }
        String attributesToExclude = "schemas,meta_location,meta_lastModified,meta_resourceType";
        String userstoreDomain = null;
        String hostAddress = args[0];
        String username = args[1];
        String password = args[2];
        String csvDirectory = DEFAULT_CSV_FILE;
        int startIndex = 1;
        int batchCount = 100;
        int maxCount = -1;
        if (!NONE.equals(args[3])) {
            csvDirectory = args[3];
        }
        String attributes = null;
        if (!NONE.equals(args[4])) {
            attributes = args[4];
        }
        if (!NONE.equals(args[5])) {
            attributesToExclude = attributesToExclude + "," + args[5];
        }
        if (!NONE.equals(args[6])) {
            userstoreDomain = args[6];
        }
        if (!NONE.equals(args[7])) {
            startIndex = Integer.parseInt(args[7]);
        }
        if (!NONE.equals(args[8])) {
            batchCount = Integer.parseInt(args[8]);
        }
        if (!NONE.equals(args[9])) {
            maxCount = Integer.parseInt(args[9]);
        }
        URIBuilder builder = new URIBuilder(hostAddress + PATH_SEPARATOR + SCIM_USER_ENDPOINT);
        CsvSchema.Builder csvSchemaBuilder = CsvSchema.builder();
        CsvSchema csvSchema = null;
        CsvMapper csvMapper = new CsvMapper();
        File file = new File(csvDirectory);
        ArrayNode usersArrayNode = new ObjectMapper().createArrayNode();
        while (true) {
            if (maxCount != -1 && maxCount < startIndex) {
                LOGGER.log(Level.INFO, "Maximum count: " + maxCount + " reached.");
                break;
            }
            if (attributes != null) {
                builder.setParameter("attributes", attributes);
            }
            if (userstoreDomain != null) {
                builder.setParameter("domain", userstoreDomain);
            }
            builder.setParameter("excludedAttributes", attributesToExclude);
            builder.setParameter("startIndex", Integer.toString(startIndex));
            builder.setParameter("count", Integer.toString(batchCount));
            LOGGER.log(Level.INFO, "Retrieving " + batchCount + " users starting from: " + startIndex);
            HttpGet request = HttpClient.createGetHttpRequest(builder, username, password);
            startIndex += batchCount;
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build();
            CloseableHttpClient client = HttpClientBuilder.create().setSSLContext(sslContext).build();
            Throwable throwable = null;
            try {
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                if (200 == response.getStatusLine().getStatusCode()) {
                    String stringResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    JsonNode jsonTree = new ObjectMapper().readTree(stringResponse);
                    JsonNode usersNode = jsonTree.at("/Resources");
                    if (usersNode.isArray()) {
                        ArrayNode arrayNode = (ArrayNode)usersNode;
                        for (int i = 0; i < arrayNode.size(); ++i) {
                            JsonNode arrayElement = arrayNode.get(i);
                            usersArrayNode.add((JsonNode)JSONFlattener.generateFlatJSON(new ObjectMapper().createObjectNode(), arrayElement, null, Collections.emptySet()));
                        }
                        if (arrayNode.size() >= batchCount) continue;
                        LOGGER.log(Level.INFO, "End of results reached.");
                        break;
                    }
                    LOGGER.log(Level.INFO, "End of results reached.");
                    break;
                }
                LOGGER.log(Level.SEVERE, request.getMethod() + " Request to " + request.getURI().toString() + " returned the status code : " + response.getStatusLine());
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                client.close();
                continue;
            }
            break;
        }
        for (int i = 0; i < usersArrayNode.size(); ++i) {
            usersArrayNode.get(i).fieldNames().forEachRemaining(fieldName -> {
                if (!csvSchemaBuilder.hasColumn(fieldName)) {
                    csvSchemaBuilder.addColumn(fieldName);
                }
            });
        }
        csvSchema = csvSchemaBuilder.build().withHeader();
        csvMapper.writerFor(ArrayNode.class).with((FormatSchema)csvSchema).writeValue((Writer)new FileWriter(file), (Object)usersArrayNode);
        if (usersArrayNode.size() == 0) {
            LOGGER.log(Level.WARNING, "Empty results returned. CSV file is not created.");
        } else {
            LOGGER.log(Level.INFO, "User information was successfully written to : " + csvDirectory + " file.");
        }
    }
}

