/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.sdk.launcher.debug;

import io.netty.channel.Channel;
import java.util.List;
import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.sdk.launcher.debug.BreakPointInfo;
import org.wso2.siddhi.sdk.launcher.debug.VMDebugManager;
import org.wso2.siddhi.sdk.launcher.debug.dto.BreakPointDTO;
import org.wso2.siddhi.sdk.launcher.debug.internal.DebugRuntime;
import org.wso2.siddhi.sdk.launcher.exception.DebugException;

public class VMDebugSession {
    private Channel channel = null;
    private DebugRuntime debugRuntime = null;

    public DebugRuntime getDebugRuntime() {
        return this.debugRuntime;
    }

    public void setDebugRuntime(DebugRuntime debugRuntime) {
        this.debugRuntime = debugRuntime;
    }

    public void addDebugPoints(List<BreakPointDTO> breakPoints) {
        for (BreakPointDTO breakPoint : breakPoints) {
            this.setBreakPoint(breakPoint);
        }
    }

    private void setBreakPoint(BreakPointDTO breakPointDTO) {
        if (breakPointDTO != null && breakPointDTO.getFileName() != null && !breakPointDTO.getFileName().isEmpty()) {
            String receivedBreakpointFileName = breakPointDTO.getFileName();
            String currentDebugFileName = this.debugRuntime.getSiddhiAppFileName();
            if (currentDebugFileName.equalsIgnoreCase(receivedBreakpointFileName)) {
                Integer queryIndex = breakPointDTO.getQueryIndex();
                String queryTerminal = breakPointDTO.getQueryTerminal();
                if (queryIndex != null && queryTerminal != null && !queryTerminal.isEmpty()) {
                    SiddhiDebugger.QueryTerminal terminal = "in".equalsIgnoreCase(queryTerminal) ? SiddhiDebugger.QueryTerminal.IN : SiddhiDebugger.QueryTerminal.OUT;
                    String queryName = (String)this.debugRuntime.getQueries().toArray()[queryIndex];
                    this.debugRuntime.getDebugger().acquireBreakPoint(queryName, terminal);
                }
            }
        }
    }

    public void removeDebugPoints(List<BreakPointDTO> breakPoints) {
        for (BreakPointDTO breakPointDTO : breakPoints) {
            if (breakPointDTO == null || breakPointDTO.getFileName() == null || breakPointDTO.getFileName().isEmpty()) continue;
            String receivedBreakpointFileName = breakPointDTO.getFileName();
            String currentDebugFileName = this.debugRuntime.getSiddhiAppFileName();
            if (!currentDebugFileName.equalsIgnoreCase(receivedBreakpointFileName)) continue;
            Integer queryIndex = breakPointDTO.getQueryIndex();
            String queryTerminal = breakPointDTO.getQueryTerminal();
            if (queryIndex == null || queryTerminal == null || queryTerminal.isEmpty()) continue;
            SiddhiDebugger.QueryTerminal terminal = "in".equalsIgnoreCase(queryTerminal) ? SiddhiDebugger.QueryTerminal.IN : SiddhiDebugger.QueryTerminal.OUT;
            String queryName = (String)this.debugRuntime.getQueries().toArray()[queryIndex];
            this.debugRuntime.getDebugger().releaseBreakPoint(queryName, terminal);
        }
    }

    public synchronized Channel getChannel() {
        return this.channel;
    }

    public synchronized void setChannel(Channel channel) throws DebugException {
        if (this.channel != null) {
            throw new DebugException("Debug session already exist");
        }
        this.channel = channel;
    }

    public void startDebug() {
        this.debugRuntime.debug();
    }

    public void stopDebug() {
        this.debugRuntime.stop();
    }

    public synchronized void clearSession() {
        this.channel.close();
        this.channel = null;
    }

    public void notifyComplete() {
        VMDebugManager debugManager = VMDebugManager.getInstance();
        debugManager.notifyComplete(this);
    }

    public void notifyExit() {
        VMDebugManager debugManager = VMDebugManager.getInstance();
        debugManager.notifyExit(this);
    }

    public void notifyHalt(BreakPointInfo breakPointInfo) {
        VMDebugManager debugManager = VMDebugManager.getInstance();
        debugManager.notifyDebugHit(this, breakPointInfo);
    }
}

