/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.sdk.launcher.debug.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.debugger.SiddhiDebugger;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.sdk.launcher.debug.BreakPointInfo;
import org.wso2.siddhi.sdk.launcher.debug.VMDebugManager;
import org.wso2.siddhi.sdk.launcher.exception.InvalidExecutionStateException;
import org.wso2.siddhi.sdk.launcher.exception.NoSuchStreamException;

public class DebugRuntime {
    private static final Logger log = Logger.getLogger(DebugRuntime.class);
    private Mode mode = Mode.STOP;
    private transient String siddhiApp;
    private transient String siddhiAppFileName;
    private transient SiddhiAppRuntime siddhiAppRuntime;
    private transient SiddhiDebugger debugger;

    public DebugRuntime(String siddhiAppFileName, String siddhiApp) {
        this.siddhiApp = siddhiApp;
        this.siddhiAppFileName = siddhiAppFileName;
        this.createRuntime();
    }

    public SiddhiAppRuntime getSiddhiAppRuntime() {
        return this.siddhiAppRuntime;
    }

    private void setSiddhiAppRuntime(SiddhiAppRuntime siddhiAppRuntime) {
        this.siddhiAppRuntime = siddhiAppRuntime;
    }

    public String getSiddhiAppFileName() {
        return this.siddhiAppFileName;
    }

    public SiddhiDebugger getDebugger() {
        return this.debugger;
    }

    public void debug() {
        if (!Mode.STOP.equals((Object)this.mode)) {
            if (Mode.FAULTY.equals((Object)this.mode)) {
                throw new InvalidExecutionStateException("Siddhi App is in faulty state.");
            }
            throw new InvalidExecutionStateException("Siddhi App is already running.");
        }
        this.debugger = this.siddhiAppRuntime.debug();
        this.debugger.setDebuggerCallback((event, queryName, queryTerminal, debugger) -> {
            String[] queries = this.getQueries().toArray(new String[this.getQueries().size()]);
            int queryIndex = Arrays.asList(queries).indexOf(queryName);
            log.info((Object)("@Debug: Query: " + queryName + ", Terminal: " + queryTerminal + ", Event: " + event));
            Map queryState = this.debugger.getQueryState(queryName);
            BreakPointInfo breakPointInfo = new BreakPointInfo(this.siddhiAppFileName, queryIndex, queryTerminal.toString());
            breakPointInfo.setQueryState(queryState);
            breakPointInfo.setQueryName(queryName);
            breakPointInfo.setEventInfo(event);
            VMDebugManager.getInstance().getDebugSession().notifyHalt(breakPointInfo);
        });
        this.mode = Mode.DEBUG;
    }

    public void stop() {
        if (this.debugger != null) {
            this.debugger.releaseAllBreakPoints();
            this.debugger.play();
            this.debugger = null;
        }
        if (this.siddhiAppRuntime != null) {
            this.siddhiAppRuntime.shutdown();
            this.siddhiAppRuntime = null;
        }
        this.createRuntime();
    }

    public List<String> getStreams() {
        if (!Mode.FAULTY.equals((Object)this.mode)) {
            return new ArrayList<String>(this.siddhiAppRuntime.getStreamDefinitionMap().keySet());
        }
        throw new InvalidExecutionStateException("Siddhi App is in faulty state.");
    }

    public List<String> getQueries() {
        if (!Mode.FAULTY.equals((Object)this.mode)) {
            return new ArrayList<String>(this.siddhiAppRuntime.getQueryNames());
        }
        throw new InvalidExecutionStateException("Siddhi App is in faulty state.");
    }

    public InputHandler getInputHandler(String streamName) {
        if (!Mode.FAULTY.equals((Object)this.mode)) {
            return this.siddhiAppRuntime.getInputHandler(streamName);
        }
        throw new InvalidExecutionStateException("Siddhi App is in faulty state.");
    }

    public List<Attribute> getStreamAttributes(String streamName) {
        if (!Mode.FAULTY.equals((Object)this.mode)) {
            if (this.siddhiAppRuntime.getStreamDefinitionMap().containsKey(streamName)) {
                return ((StreamDefinition)this.siddhiAppRuntime.getStreamDefinitionMap().get(streamName)).getAttributeList();
            }
            throw new NoSuchStreamException("Stream definition %s does not exists in Siddhi app " + streamName);
        }
        throw new InvalidExecutionStateException("Siddhi App is in faulty state.");
    }

    private void createRuntime() {
        if (this.siddhiApp != null && !this.siddhiApp.isEmpty()) {
            this.siddhiAppRuntime = VMDebugManager.getInstance().getSiddhiManager().createSiddhiAppRuntime(this.siddhiApp);
            this.setSiddhiAppRuntime(this.siddhiAppRuntime);
            this.mode = Mode.STOP;
        } else {
            this.mode = Mode.FAULTY;
        }
    }

    private static enum Mode {
        DEBUG,
        STOP,
        FAULTY;

    }
}

