/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.sdk.launcher.debug.internal;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.sdk.launcher.debug.VMDebugSession;
import org.wso2.siddhi.sdk.launcher.debug.internal.DebugRuntime;
import org.wso2.siddhi.sdk.launcher.debug.internal.EventStreamService;
import org.wso2.siddhi.sdk.launcher.exception.NoSuchStreamException;
import org.wso2.siddhi.sdk.launcher.exception.ResourceNotFoundException;

public class DebuggerEventStreamService
implements EventStreamService {
    private static Logger log = LoggerFactory.getLogger(DebuggerEventStreamService.class);
    private VMDebugSession debugSession;

    public VMDebugSession getDebugSession() {
        return this.debugSession;
    }

    public void setDebugSession(VMDebugSession debugSession) {
        this.debugSession = debugSession;
    }

    @Override
    public List<String> getStreamNames(String siddhiAppName) {
        DebugRuntime runtimeHolder = this.debugSession.getDebugRuntime();
        if (runtimeHolder != null) {
            return runtimeHolder.getStreams();
        }
        log.error("Siddhi App with name : " + siddhiAppName + " is not available");
        return null;
    }

    @Override
    public List<Attribute> getStreamAttributes(String siddhiAppName, String streamName) throws ResourceNotFoundException {
        DebugRuntime runtimeHolder = this.debugSession.getDebugRuntime();
        if (runtimeHolder != null) {
            try {
                return runtimeHolder.getStreamAttributes(streamName);
            }
            catch (NoSuchStreamException e) {
                throw new ResourceNotFoundException("Siddhi App '" + siddhiAppName + "' does not contain " + "stream '" + streamName + "'.", ResourceNotFoundException.ResourceType.STREAM_NAME, streamName);
            }
        }
        throw new ResourceNotFoundException("Siddhi App '" + siddhiAppName + "' does not exist.", ResourceNotFoundException.ResourceType.SIDDHI_APP_NAME, siddhiAppName);
    }

    @Override
    public void pushEvent(String siddhiAppName, String streamName, Event event) {
        DebugRuntime runtimeHolder = this.debugSession.getDebugRuntime();
        if (runtimeHolder != null) {
            try {
                runtimeHolder.getInputHandler(streamName).send(event);
            }
            catch (Exception e) {
                log.error("Error when pushing events to Siddhi debugger engine ", (Throwable)e);
            }
        }
    }
}

