/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.performance;

import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.output.StreamCallback;

public class SimpleFilterSyncPerformance {
    private static int count = 0;
    private static volatile long start = System.currentTimeMillis();

    public static void main(String[] args) throws InterruptedException {
        SiddhiManager siddhiManager = new SiddhiManager();
        String cseEventStream = " define stream RequestStream (messageID string, app_key string, api_key string, app_tier string, api_tier string, user_id string, properties string, timeNow long); define stream EligibilityStream (rule string, messageID string, isEligible bool, isLocallyThrottled bool, throttle_key string , timeNow long); ";
        String query = "@info(name = 'query1') FROM RequestStream SELECT 'sub_gold' AS rule, messageID, ( api_tier == 'Gold') AS isEligible,false as isLocallyThrottled,  'sub_gold_TEST1TEST1Test1_key' AS throttle_key , timeNow \nINSERT INTO EligibilityStream; @info(name = 'query2') FROM EligibilityStream[isEligible==false]\n\t\tSELECT rule, messageID, false AS isThrottled , timeNow\n\t\tINSERT INTO ThrottleStream;\n\n@info(name = 'query3') FROM EligibilityStream[isEligible==true AND isLocallyThrottled==true]\n\t\tSELECT rule, messageID, true AS isThrottled , timeNow \n\t\tINSERT INTO ThrottleStream; \n\n@info(name = 'query4') FROM EligibilityStream[isEligible==true AND isLocallyThrottled==false]\n\t\tSELECT rule, messageID, false AS isThrottled, timeNow \n\t\tINSERT INTO ThrottleStream;  ";
        ExecutionPlanRuntime executionPlanRuntime = siddhiManager.createExecutionPlanRuntime(cseEventStream + query);
        executionPlanRuntime.addCallback("ThrottleStream", new StreamCallback(){
            public int eventCount = 0;
            public int timeSpent = 0;
            long startTime = System.currentTimeMillis();

            public void receive(Event[] events) {
                for (Event event : events) {
                    ++this.eventCount;
                    this.timeSpent = (int)((long)this.timeSpent + (System.currentTimeMillis() - (Long)event.getData(3)));
                    if (this.eventCount % 1000000 != 0) continue;
                    System.out.println("Throughput : " + (long)(this.eventCount * 1000) / (System.currentTimeMillis() - this.startTime));
                    System.out.println("Time spend :  " + (double)this.timeSpent * 1.0 / (double)this.eventCount);
                    this.startTime = System.currentTimeMillis();
                    this.eventCount = 0;
                    this.timeSpent = 0;
                }
            }
        });
        InputHandler inputHandler = executionPlanRuntime.getInputHandler("RequestStream");
        executionPlanRuntime.start();
        for (int i = 0; i <= 100; ++i) {
            EventPublisher eventPublisher = new EventPublisher(inputHandler);
            eventPublisher.run();
        }
    }

    static class EventPublisher
    implements Runnable {
        InputHandler inputHandler;

        EventPublisher(InputHandler inputHandler) {
            this.inputHandler = inputHandler;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.inputHandler.send(new Object[]{"IBM", "TEST1", "TEST1", "TEST1", "Gold", "Test1", null, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", "TEST1", "TEST1", "TEST1", "Gold", "Test1", null, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", "TEST1", "TEST1", "TEST1", "Gold", "Test1", null, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", "TEST1", "TEST1", "TEST1", "Gold", "Test1", null, System.currentTimeMillis()});
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

