/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.evalscript;

import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.function.EvalScript;
import org.wso2.siddhi.extension.evalscript.ScalaEvaluationEngine;
import org.wso2.siddhi.query.api.definition.Attribute;
import scala.Function1;

public class EvalScala
implements EvalScript {
    private Function1<Object[], Object> scalaFunction;
    private Attribute.Type returnType;
    private String functionName;

    public void init(String name, String body) {
        this.functionName = name;
        if (this.returnType == null) {
            throw new ExecutionPlanCreationException("Cannot find the return type of the function " + this.functionName);
        }
        ScalaEvaluationEngine scalaEvaluationEngine = new ScalaEvaluationEngine();
        try {
            this.scalaFunction = scalaEvaluationEngine.eval("data: (Array[Any]) =>  {\n" + body + "\n}");
        }
        catch (Exception e) {
            throw new ExecutionPlanCreationException("Compilation Failure of the Scala Function " + name, (Throwable)e);
        }
    }

    public Object eval(String name, Object[] arg) {
        try {
            return this.scalaFunction.apply((Object)arg);
        }
        catch (Exception e) {
            throw new ExecutionPlanRuntimeException("Error while evaluating function " + name, (Throwable)e);
        }
    }

    public void setReturnType(Attribute.Type returnType) {
        this.returnType = returnType;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

