/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.table.holder.EventHolder;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.extension.eventtable.hazelcast.HazelcastCollectionEventHolder;
import org.wso2.siddhi.extension.eventtable.hazelcast.HazelcastOperatorParser;
import org.wso2.siddhi.extension.eventtable.hazelcast.HazelcastPrimaryKeyEventHolder;
import org.wso2.siddhi.extension.eventtable.hazelcast.internal.ds.HazelcastEventTableServiceValueHolder;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class HazelcastEventTable
implements EventTable {
    private static final Log logger = LogFactory.getLog(HazelcastEventTable.class);
    private final ZeroStreamEventConverter eventConverter = new ZeroStreamEventConverter();
    private TableDefinition tableDefinition;
    private ExecutionPlanContext executionPlanContext;
    private StreamEventCloner tableStreamEventCloner;
    private String elementId;
    private EventHolder eventHolder = null;

    public void init(TableDefinition tableDefinition, MetaStreamEvent tableMetaStreamEvent, StreamEventPool tableStreamEventPool, StreamEventCloner tableStreamEventCloner, ExecutionPlanContext executionPlanContext) {
        boolean serverMode;
        this.tableDefinition = tableDefinition;
        this.tableStreamEventCloner = tableStreamEventCloner;
        this.executionPlanContext = executionPlanContext;
        Annotation fromAnnotation = AnnotationHelper.getAnnotation((String)"from", (List)tableDefinition.getAnnotations());
        String clusterName = fromAnnotation.getElement("cluster.name");
        String clusterPassword = fromAnnotation.getElement("cluster.password");
        String hosts = fromAnnotation.getElement("cluster.addresses");
        String collectionName = fromAnnotation.getElement("collection.name");
        Annotation annotation = AnnotationHelper.getAnnotation((String)"IndexBy", (List)tableDefinition.getAnnotations());
        boolean bl = serverMode = hosts == null || hosts.isEmpty();
        if (serverMode) {
            hosts = fromAnnotation.getElement("well.known.addresses");
        }
        if (collectionName == null || collectionName.isEmpty()) {
            collectionName = "org.wso2.siddhi.hazelcast.cluster.collection." + executionPlanContext.getName() + '.' + tableDefinition.getId();
        }
        MetaStreamEvent metaStreamEvent = new MetaStreamEvent();
        metaStreamEvent.addInputDefinition((AbstractDefinition)tableDefinition);
        for (Attribute attribute : tableDefinition.getAttributeList()) {
            metaStreamEvent.addOutputData(attribute);
        }
        HazelcastInstance hzInstance = this.getHazelcastInstance(serverMode, clusterName, clusterPassword, hosts);
        if (annotation != null) {
            if (annotation.getElements().size() != 1) {
                throw new OperationNotSupportedException("IndexBy annotation of table " + tableDefinition.getId() + " contains " + annotation.getElements().size() + " elements, Siddhi Hazelcast event table only supports indexing based on a single attribute");
            }
            String indexAttribute = ((Element)annotation.getElements().get(0)).getValue();
            int indexPosition = tableDefinition.getAttributePosition(indexAttribute);
            this.eventHolder = new HazelcastPrimaryKeyEventHolder(hzInstance.getMap(collectionName), tableStreamEventPool, (StreamEventConverter)this.eventConverter, indexPosition, indexAttribute);
        } else {
            this.eventHolder = new HazelcastCollectionEventHolder(hzInstance.getList(collectionName), tableStreamEventPool, (StreamEventConverter)this.eventConverter);
        }
        if (this.elementId == null) {
            this.elementId = executionPlanContext.getElementIdGenerator().createNewId();
        }
    }

    protected HazelcastInstance getHazelcastInstance(boolean serverMode, String groupName, String groupPassword, String addresses) {
        if (HazelcastEventTableServiceValueHolder.getHazelcastInstance() != null && addresses == null) {
            return HazelcastEventTableServiceValueHolder.getHazelcastInstance();
        }
        if (serverMode) {
            Config config = new Config();
            config.setProperty("hazelcast.logging.type", "log4j");
            config.setInstanceName("org.wso2.siddhi.hazelcast.cluster.instance." + this.executionPlanContext.getName());
            if (groupName != null && !groupName.isEmpty()) {
                config.getGroupConfig().setName(groupName);
            }
            if (groupPassword != null && !groupPassword.isEmpty()) {
                config.getGroupConfig().setPassword(groupPassword);
            }
            if (addresses != null && !addresses.isEmpty()) {
                JoinConfig joinConfig = config.getNetworkConfig().getJoin();
                joinConfig.getMulticastConfig().setEnabled(false);
                joinConfig.getTcpIpConfig().setEnabled(true);
                for (String ip : addresses.split(",")) {
                    joinConfig.getTcpIpConfig().addMember(ip);
                }
            }
            return Hazelcast.getOrCreateHazelcastInstance((Config)config);
        }
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.logging.type", "log4j");
        if (groupName != null && !groupName.isEmpty()) {
            clientConfig.getGroupConfig().setName(groupName);
        }
        if (groupPassword != null && !groupPassword.isEmpty()) {
            clientConfig.getGroupConfig().setPassword(groupPassword);
        }
        clientConfig.setNetworkConfig(clientConfig.getNetworkConfig().addAddress(addresses.split(",")));
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    public synchronized void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        this.eventHolder.add(addingEventChunk);
    }

    public synchronized void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Operator operator) {
        operator.delete(deletingEventChunk, (Object)this.eventHolder);
    }

    public synchronized void update(ComplexEventChunk<StateEvent> updatingEventChunk, Operator operator, UpdateAttributeMapper[] updateAttributeMappers) {
        operator.update(updatingEventChunk, (Object)this.eventHolder, updateAttributeMappers);
    }

    public synchronized void overwriteOrAdd(ComplexEventChunk<StateEvent> overwritingOrAddingEventChunk, Operator operator, UpdateAttributeMapper[] updateAttributeMappers, OverwritingStreamEventExtractor overwritingStreamEventExtractor) {
        ComplexEventChunk failedEvents = operator.overwriteOrAdd(overwritingOrAddingEventChunk, (Object)this.eventHolder, updateAttributeMappers, overwritingStreamEventExtractor);
        this.eventHolder.add(failedEvents);
    }

    public synchronized boolean contains(StateEvent matchingEvent, Finder finder) {
        return finder.contains(matchingEvent, (Object)this.eventHolder);
    }

    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, (Object)this.eventHolder, this.tableStreamEventCloner);
    }

    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return HazelcastOperatorParser.constructOperator(this.eventHolder, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.tableDefinition.getId());
    }

    public Operator constructOperator(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return HazelcastOperatorParser.constructOperator(this.eventHolder, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.tableDefinition.getId());
    }
}

