/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.exception.CannotLoadConfigurationException;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.extension.eventtable.cache.CachingTable;
import org.wso2.siddhi.extension.eventtable.rdbms.DBHandler;
import org.wso2.siddhi.extension.eventtable.rdbms.DBQueryHelper;
import org.wso2.siddhi.extension.eventtable.rdbms.PooledDataSource;
import org.wso2.siddhi.extension.eventtable.rdbms.RDBMSOperator;
import org.wso2.siddhi.extension.eventtable.rdbms.RDBMSOperatorParser;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.util.AnnotationHelper;

public class RDBMSEventTable
implements EventTable {
    private TableDefinition tableDefinition;
    private DBHandler dbHandler;
    private CachingTable cachedTable;
    private String cacheSizeInString;
    private boolean isCachingEnabled;
    private static final Log log = LogFactory.getLog(RDBMSEventTable.class);

    public void init(TableDefinition tableDefinition, MetaStreamEvent tableMetaStreamEvent, StreamEventPool tableStreamEventPool, StreamEventCloner tableStreamEventCloner, ExecutionPlanContext executionPlanContext) {
        this.tableDefinition = tableDefinition;
        Connection con = null;
        int bloomFilterSize = 10000;
        int bloomFilterHashFunctions = 4;
        Annotation fromAnnotation = AnnotationHelper.getAnnotation((String)"from", (List)tableDefinition.getAnnotations());
        String dataSourceName = fromAnnotation.getElement("datasource.name");
        String tableName = fromAnnotation.getElement("table.name");
        DataSource dataSource = executionPlanContext.getSiddhiContext().getSiddhiDataSource(dataSourceName);
        List attributeList = tableDefinition.getAttributeList();
        if (dataSource == null && dataSourceName == null) {
            String jdbcConnectionUrl = fromAnnotation.getElement("jdbc.url");
            String username = fromAnnotation.getElement("username");
            String password = fromAnnotation.getElement("password");
            String driverName = fromAnnotation.getElement("driver.name");
            List connectionPropertyElements = null;
            Annotation connectionAnnotation = AnnotationHelper.getAnnotation((String)"connection", (List)tableDefinition.getAnnotations());
            if (connectionAnnotation != null) {
                connectionPropertyElements = connectionAnnotation.getElements();
            }
            dataSource = PooledDataSource.getPoolDataSource(driverName, jdbcConnectionUrl, username, password, connectionPropertyElements);
        }
        if (dataSource == null) {
            throw new ExecutionPlanCreationException("Datasource specified for the event table is invalid/null");
        }
        if (tableName == null) {
            throw new ExecutionPlanCreationException("Invalid query specified. Required properties (tableName) not found ");
        }
        String cacheType = fromAnnotation.getElement("cache");
        this.cacheSizeInString = fromAnnotation.getElement("cache.size");
        String cacheLoadingType = fromAnnotation.getElement("cache.loading");
        String cacheValidityInterval = fromAnnotation.getElement("cache.validity");
        String bloomsEnabled = fromAnnotation.getElement("bloom.filters");
        String bloomFilterValidityInterval = fromAnnotation.getElement("bloom.validity");
        try {
            this.dbHandler = new DBHandler(dataSource, tableName, attributeList, tableDefinition);
            con = dataSource.getConnection();
            if (con == null) {
                throw new ExecutionPlanCreationException("Error while making connection to database");
            }
            if (cacheType != null) {
                this.cachedTable = new CachingTable(cacheType, this.cacheSizeInString, executionPlanContext, tableDefinition);
                this.isCachingEnabled = true;
                if (cacheLoadingType != null && cacheLoadingType.equalsIgnoreCase("eager")) {
                    this.dbHandler.loadDBCache(this.cachedTable, this.cacheSizeInString);
                }
                if (cacheValidityInterval != null) {
                    Long cacheTimeInterval = Long.parseLong(cacheValidityInterval);
                    Timer timer = new Timer();
                    CacheUpdateTask cacheUpdateTask = new CacheUpdateTask();
                    timer.schedule((TimerTask)cacheUpdateTask, cacheTimeInterval);
                }
            } else if (bloomsEnabled != null && bloomsEnabled.equalsIgnoreCase("enable")) {
                String bloomsFilterSize = fromAnnotation.getElement("bloom.filters.size");
                String bloomsFilterHash = fromAnnotation.getElement("bloom.filters.hash");
                if (bloomsFilterSize != null) {
                    bloomFilterSize = Integer.parseInt(bloomsFilterSize);
                }
                if (bloomsFilterHash != null) {
                    bloomFilterHashFunctions = Integer.parseInt(bloomsFilterHash);
                }
                this.dbHandler.setBloomFilters(bloomFilterSize, bloomFilterHashFunctions);
                this.dbHandler.buildBloomFilters();
                if (bloomFilterValidityInterval != null) {
                    Long bloomTimeInterval = Long.parseLong(bloomFilterValidityInterval);
                    Timer timer = new Timer();
                    BloomsUpdateTask bloomsUpdateTask = new BloomsUpdateTask();
                    timer.schedule((TimerTask)bloomsUpdateTask, bloomTimeInterval, (long)bloomTimeInterval);
                }
            }
        }
        catch (SQLException e) {
            throw new ExecutionPlanCreationException("Error while making connection to database", (Throwable)e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    log.error((Object)"unable to release connection", (Throwable)e);
                }
            }
        }
    }

    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        this.dbHandler.addEvent(addingEventChunk);
    }

    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Operator operator, UpdateAttributeMapper[] updateAttributeMappers) {
        operator.update(updatingEventChunk, null, null);
        if (this.isCachingEnabled) {
            ((RDBMSOperator)operator).getInMemoryEventTableOperator().update(updatingEventChunk, this.cachedTable.getCacheList(), updateAttributeMappers);
        }
    }

    public void overwriteOrAdd(ComplexEventChunk<StateEvent> overwritingOrAddingEventChunk, Operator operator, UpdateAttributeMapper[] updateAttributeMappers, OverwritingStreamEventExtractor overwritingStreamEventExtractor) {
        operator.overwriteOrAdd(overwritingOrAddingEventChunk, null, null, overwritingStreamEventExtractor);
        if (this.isCachingEnabled) {
            ((RDBMSOperator)operator).getInMemoryEventTableOperator().overwriteOrAdd(overwritingOrAddingEventChunk, this.cachedTable.getCacheList(), updateAttributeMappers, overwritingStreamEventExtractor);
        }
    }

    public synchronized boolean contains(StateEvent matchingEvent, Finder finder) {
        if (this.isCachingEnabled) {
            return ((RDBMSOperator)finder).getInMemoryEventTableOperator().contains(matchingEvent, this.cachedTable.getCacheList()) || finder.contains(matchingEvent, null);
        }
        return finder.contains(matchingEvent, null);
    }

    public synchronized void delete(ComplexEventChunk deletingEventChunk, Operator operator) {
        operator.delete(deletingEventChunk, null);
        if (this.isCachingEnabled) {
            ((RDBMSOperator)operator).getInMemoryEventTableOperator().delete(deletingEventChunk, this.cachedTable.getCacheList());
        }
    }

    public Operator constructOperator(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return RDBMSOperatorParser.parse(this.dbHandler, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.tableDefinition, this.cachedTable, this.tableDefinition.getId());
    }

    public synchronized StreamEvent find(StateEvent matchingEvent, Finder finder) {
        return finder.find(matchingEvent, null, null);
    }

    public Finder constructFinder(Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap) {
        return RDBMSOperatorParser.parse(this.dbHandler, expression, matchingMetaStateHolder, executionPlanContext, variableExpressionExecutors, eventTableMap, this.tableDefinition, this.cachedTable, this.tableDefinition.getId());
    }

    static {
        try {
            DBQueryHelper.loadConfiguration();
        }
        catch (CannotLoadConfigurationException e) {
            throw new ExecutionPlanCreationException("Error while loading the rdbms configuration file", (Throwable)e);
        }
    }

    class BloomsUpdateTask
    extends TimerTask {
        BloomsUpdateTask() {
        }

        @Override
        public void run() {
            RDBMSEventTable.this.dbHandler.buildBloomFilters();
        }
    }

    class CacheUpdateTask
    extends TimerTask {
        CacheUpdateTask() {
        }

        @Override
        public void run() {
            RDBMSEventTable.this.cachedTable.invalidateCache();
            RDBMSEventTable.this.dbHandler.loadDBCache(RDBMSEventTable.this.cachedTable, RDBMSEventTable.this.cacheSizeInString);
        }
    }
}

