/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.hazelcast;

import com.hazelcast.core.IList;
import java.util.Collection;
import java.util.Iterator;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.ZeroStreamEventConverter;
import org.wso2.siddhi.core.table.holder.EventHolder;

public class HazelcastCollectionEventHolder
implements EventHolder,
Collection<StreamEvent> {
    private IList<StreamEvent> candidateDataList;
    private StreamEventPool tableStreamEventPool;
    private StreamEventConverter eventConverter = new ZeroStreamEventConverter();

    public HazelcastCollectionEventHolder(IList candidateDataList, StreamEventPool tableStreamEventPool, StreamEventConverter eventConverter) {
        this.candidateDataList = candidateDataList;
        this.tableStreamEventPool = tableStreamEventPool;
        this.eventConverter = eventConverter;
    }

    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        addingEventChunk.reset();
        while (addingEventChunk.hasNext()) {
            ComplexEvent complexEvent = addingEventChunk.next();
            StreamEvent streamEvent = this.tableStreamEventPool.borrowEvent();
            this.eventConverter.convertComplexEvent(complexEvent, streamEvent);
            this.candidateDataList.add((Object)streamEvent);
        }
    }

    @Override
    public int size() {
        return this.candidateDataList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.candidateDataList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.candidateDataList.contains(o);
    }

    @Override
    public Iterator<StreamEvent> iterator() {
        return this.candidateDataList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.candidateDataList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.candidateDataList.toArray((Object[])a);
    }

    @Override
    public boolean add(StreamEvent streamEvent) {
        return this.candidateDataList.add((Object)streamEvent);
    }

    @Override
    public boolean remove(Object o) {
        return this.candidateDataList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.candidateDataList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends StreamEvent> c) {
        return this.candidateDataList.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.candidateDataList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.candidateDataList.retainAll(c);
    }

    @Override
    public void clear() {
        this.candidateDataList.clear();
    }

    public StreamEvent get(int i) {
        return (StreamEvent)this.candidateDataList.get(i);
    }

    public void set(int i, StreamEvent candidateEvent) {
        this.candidateDataList.set(i, (Object)candidateEvent);
    }
}

