/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.hazelcast;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.table.EventTable;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaStateHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.parser.ExpressionParser;
import org.wso2.siddhi.extension.eventtable.hazelcast.HazelcastCollectionOperator;
import org.wso2.siddhi.extension.eventtable.hazelcast.HazelcastMapOperator;
import org.wso2.siddhi.extension.eventtable.hazelcast.HazelcastPrimaryKeyEventHolder;
import org.wso2.siddhi.extension.eventtable.hazelcast.HazelcastPrimaryKeyOperator;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.expression.condition.Compare;
import org.wso2.siddhi.query.api.expression.constant.Constant;

public class HazelcastOperatorParser {
    private HazelcastOperatorParser() {
    }

    public static Operator constructOperator(Object candidateEvents, Expression expression, MatchingMetaStateHolder matchingMetaStateHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, EventTable> eventTableMap, String queryName) {
        if (candidateEvents instanceof HazelcastPrimaryKeyEventHolder) {
            Compare compare;
            if (expression instanceof Compare && ((Compare)expression).getOperator() == Compare.Operator.EQUAL && ((compare = (Compare)expression).getLeftExpression() instanceof Variable || compare.getLeftExpression() instanceof Constant) && (compare.getRightExpression() instanceof Variable || compare.getRightExpression() instanceof Constant)) {
                boolean leftSideIndexed = false;
                boolean rightSideIndexed = false;
                if (HazelcastOperatorParser.isTableIndexVariable(matchingMetaStateHolder, compare.getLeftExpression(), ((HazelcastPrimaryKeyEventHolder)candidateEvents).getIndexAttribute())) {
                    leftSideIndexed = true;
                }
                if (HazelcastOperatorParser.isTableIndexVariable(matchingMetaStateHolder, compare.getRightExpression(), ((HazelcastPrimaryKeyEventHolder)candidateEvents).getIndexAttribute())) {
                    rightSideIndexed = true;
                }
                if (leftSideIndexed && !rightSideIndexed) {
                    ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression((Expression)compare.getRightExpression(), (MetaComplexEvent)matchingMetaStateHolder.getMetaStateEvent(), (int)matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, (ExecutionPlanContext)executionPlanContext, (boolean)false, (int)0, (String)queryName);
                    return new HazelcastPrimaryKeyOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex(), ((HazelcastPrimaryKeyEventHolder)candidateEvents).getIndexPosition());
                }
                if (!leftSideIndexed && rightSideIndexed) {
                    ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression((Expression)compare.getLeftExpression(), (MetaComplexEvent)matchingMetaStateHolder.getMetaStateEvent(), (int)matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, (ExecutionPlanContext)executionPlanContext, (boolean)false, (int)0, (String)queryName);
                    return new HazelcastPrimaryKeyOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex(), ((HazelcastPrimaryKeyEventHolder)candidateEvents).getIndexPosition());
                }
            }
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression((Expression)expression, (MetaComplexEvent)matchingMetaStateHolder.getMetaStateEvent(), (int)matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, (ExecutionPlanContext)executionPlanContext, (boolean)false, (int)0, (String)queryName);
            return new HazelcastMapOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex());
        }
        if (candidateEvents instanceof Collection) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression((Expression)expression, (MetaComplexEvent)matchingMetaStateHolder.getMetaStateEvent(), (int)matchingMetaStateHolder.getDefaultStreamEventIndex(), eventTableMap, variableExpressionExecutors, (ExecutionPlanContext)executionPlanContext, (boolean)false, (int)0, (String)queryName);
            return new HazelcastCollectionOperator(expressionExecutor, matchingMetaStateHolder.getCandidateEventIndex());
        }
        throw new OperationNotSupportedException(candidateEvents.getClass() + " is not supported by OperatorParser!");
    }

    private static boolean isTableIndexVariable(MatchingMetaStateHolder matchingMetaStateHolder, Expression expression, String indexAttribute) {
        MetaStreamEvent tableStreamEvent;
        Variable variable;
        return expression instanceof Variable && (variable = (Variable)expression).getStreamId() != null && ((tableStreamEvent = matchingMetaStateHolder.getMetaStateEvent().getMetaStreamEvent(matchingMetaStateHolder.getCandidateEventIndex())) != null ? (tableStreamEvent.getInputReferenceId() != null && variable.getStreamId().equals(tableStreamEvent.getInputReferenceId()) || tableStreamEvent.getLastInputDefinition().getId().equals(variable.getStreamId())) && Arrays.asList(tableStreamEvent.getLastInputDefinition().getAttributeNameArray()).contains(indexAttribute) : matchingMetaStateHolder.getCandsidateDefinition().getId().equals(variable.getStreamId()));
    }
}

