/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.hazelcast;

import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.table.holder.EventHolder;

public class HazelcastPrimaryKeyEventHolder
implements EventHolder,
Map<Object, StreamEvent> {
    private IMap<Object, StreamEvent> candidateDataMap;
    private StreamEventPool tableStreamEventPool;
    private StreamEventConverter eventConverter;
    private int indexPosition;
    private String indexAttribute;

    public HazelcastPrimaryKeyEventHolder(IMap candidateDataMap, StreamEventPool tableStreamEventPool, StreamEventConverter eventConverter, int indexPosition, String indexAttribute) {
        this.candidateDataMap = candidateDataMap;
        this.tableStreamEventPool = tableStreamEventPool;
        this.eventConverter = eventConverter;
        this.indexPosition = indexPosition;
        this.indexAttribute = indexAttribute;
    }

    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        addingEventChunk.reset();
        while (addingEventChunk.hasNext()) {
            ComplexEvent complexEvent = addingEventChunk.next();
            StreamEvent streamEvent = this.tableStreamEventPool.borrowEvent();
            this.eventConverter.convertComplexEvent(complexEvent, streamEvent);
            this.candidateDataMap.put(streamEvent.getOutputData()[this.indexPosition], (Object)streamEvent);
        }
    }

    public String getIndexAttribute() {
        return this.indexAttribute;
    }

    public int getIndexPosition() {
        return this.indexPosition;
    }

    @Override
    public int size() {
        return this.candidateDataMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.candidateDataMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.candidateDataMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(value);
    }

    @Override
    public StreamEvent get(Object key) {
        return (StreamEvent)this.candidateDataMap.get(key);
    }

    @Override
    public StreamEvent put(Object key, StreamEvent value) {
        return (StreamEvent)this.candidateDataMap.put(key, (Object)value);
    }

    @Override
    public StreamEvent replace(Object key, StreamEvent value) {
        return (StreamEvent)this.candidateDataMap.replace(key, (Object)value);
    }

    @Override
    public StreamEvent remove(Object key) {
        return (StreamEvent)this.candidateDataMap.remove(key);
    }

    @Override
    public void putAll(Map<?, ? extends StreamEvent> m) {
        this.candidateDataMap.putAll(m);
    }

    @Override
    public void clear() {
        this.candidateDataMap.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.candidateDataMap.keySet();
    }

    @Override
    public Collection<StreamEvent> values() {
        return this.candidateDataMap.values();
    }

    @Override
    public Set<Map.Entry<Object, StreamEvent>> entrySet() {
        return this.candidateDataMap.entrySet();
    }
}

