/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.eventtable.hazelcast;

import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.extension.eventtable.hazelcast.HazelcastPrimaryKeyEventHolder;

public class HazelcastPrimaryKeyOperator
implements Operator {
    protected final ExpressionExecutor expressionExecutor;
    protected final int candidateEventPosition;
    protected final int indexPosition;

    public HazelcastPrimaryKeyOperator(ExpressionExecutor expressionExecutor, int candidateEventPosition, int indexPosition) {
        this.expressionExecutor = expressionExecutor;
        this.candidateEventPosition = candidateEventPosition;
        this.indexPosition = indexPosition;
    }

    public Finder cloneFinder(String key) {
        return new HazelcastPrimaryKeyOperator(this.expressionExecutor.cloneExecutor(key), this.candidateEventPosition, this.indexPosition);
    }

    public StreamEvent find(StateEvent matchingEvent, Object candidateEvents, StreamEventCloner candidateEventCloner) {
        Object matchingKey = this.expressionExecutor.execute((ComplexEvent)matchingEvent);
        StreamEvent streamEvent = ((HazelcastPrimaryKeyEventHolder)candidateEvents).get(matchingKey);
        if (streamEvent == null) {
            return null;
        }
        return candidateEventCloner.copyStreamEvent(streamEvent);
    }

    public boolean contains(StateEvent matchingEvent, Object candidateEvents) {
        Object matchingKey = this.expressionExecutor.execute((ComplexEvent)matchingEvent);
        StreamEvent streamEvent = ((HazelcastPrimaryKeyEventHolder)candidateEvents).get(matchingKey);
        return streamEvent != null;
    }

    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object candidateEvents) {
        deletingEventChunk.reset();
        while (deletingEventChunk.hasNext()) {
            StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
            Object matchingKey = this.expressionExecutor.execute((ComplexEvent)deletingEvent);
            ((HazelcastPrimaryKeyEventHolder)candidateEvents).remove(matchingKey);
        }
    }

    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers) {
        updatingEventChunk.reset();
        while (updatingEventChunk.hasNext()) {
            StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
            Object matchingKey = this.expressionExecutor.execute((ComplexEvent)updatingEvent);
            StreamEvent streamEvent = ((HazelcastPrimaryKeyEventHolder)candidateEvents).get(matchingKey);
            if (streamEvent == null) continue;
            for (UpdateAttributeMapper updateAttributeMapper : updateAttributeMappers) {
                streamEvent.setOutputData(updateAttributeMapper.getOutputData(updatingEvent), updateAttributeMapper.getCandidateAttributePosition());
            }
            ((HazelcastPrimaryKeyEventHolder)candidateEvents).replace(matchingKey, streamEvent);
        }
    }

    public ComplexEventChunk<StreamEvent> overwriteOrAdd(ComplexEventChunk<StateEvent> overwritingOrAddingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers, OverwritingStreamEventExtractor overwritingStreamEventExtractor) {
        overwritingOrAddingEventChunk.reset();
        ComplexEventChunk failedEventChunk = new ComplexEventChunk(overwritingOrAddingEventChunk.isBatch());
        while (overwritingOrAddingEventChunk.hasNext()) {
            StateEvent overwritingOrAddingEvent = (StateEvent)overwritingOrAddingEventChunk.next();
            Object matchingKey = this.expressionExecutor.execute((ComplexEvent)overwritingOrAddingEvent);
            StreamEvent streamEvent = ((HazelcastPrimaryKeyEventHolder)candidateEvents).get(matchingKey);
            if (streamEvent != null) {
                for (UpdateAttributeMapper updateAttributeMapper : updateAttributeMappers) {
                    streamEvent.setOutputData(updateAttributeMapper.getOutputData(overwritingOrAddingEvent), updateAttributeMapper.getCandidateAttributePosition());
                }
                ((HazelcastPrimaryKeyEventHolder)candidateEvents).replace(matchingKey, streamEvent);
                continue;
            }
            failedEventChunk.add((ComplexEvent)overwritingStreamEventExtractor.getOverwritingStreamEvent(overwritingOrAddingEvent));
        }
        return failedEventChunk;
    }
}

